/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveReduceV3", inputsClass=Inputs.class)
public final class CollectiveReduce<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveReduceV3";
    private Output<T> data;

    public CollectiveReduce(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CollectiveReduce<T> create(Scope scope, Operand<T> input, Operand<? extends TType> communicator, Operand<TInt32> groupAssignment, String reduction, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CollectiveReduce");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(communicator.asOutput());
        opBuilder.addInput(groupAssignment.asOutput());
        opBuilder.setAttr("reduction", reduction);
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new CollectiveReduce<T>(opBuilder.build());
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    @OpInputsMetadata(outputsClass=CollectiveReduce.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CollectiveReduce<T>> {
        public final Operand<T> input;
        public final Operand<? extends TType> communicator;
        public final Operand<TInt32> groupAssignment;
        public final DataType T;
        public final String reduction;
        public final float timeoutSeconds;

        public Inputs(GraphOperation op) {
            super(new CollectiveReduce(op), op, Arrays.asList("T", "reduction", "timeout_seconds"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.communicator = op.input(inputIndex++);
            this.groupAssignment = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.reduction = op.attributes().getAttrString("reduction");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
        }
    }

    public static class Options {
        private Float timeoutSeconds;

        private Options() {
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }
    }
}

