/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.ragged.RaggedBincount;
import org.tensorflow.op.ragged.RaggedCountSparseOutput;
import org.tensorflow.op.ragged.RaggedCross;
import org.tensorflow.op.ragged.RaggedFillEmptyRows;
import org.tensorflow.op.ragged.RaggedFillEmptyRowsGrad;
import org.tensorflow.op.ragged.RaggedGather;
import org.tensorflow.op.ragged.RaggedRange;
import org.tensorflow.op.ragged.RaggedTensorFromVariant;
import org.tensorflow.op.ragged.RaggedTensorToSparse;
import org.tensorflow.op.ragged.RaggedTensorToTensor;
import org.tensorflow.op.ragged.RaggedTensorToVariant;
import org.tensorflow.op.ragged.RaggedTensorToVariantGradient;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RaggedOps {
    private final Scope scope;
    private final Ops ops;

    RaggedOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <U extends TNumber, T extends TNumber> RaggedBincount<U> raggedBincount(Operand<TInt64> splits, Operand<T> values, Operand<T> sizeOutput, Operand<U> weights, RaggedBincount.Options ... options) {
        return RaggedBincount.create(this.scope, splits, values, sizeOutput, weights, options);
    }

    public <U extends TNumber> RaggedCountSparseOutput<U> raggedCountSparseOutput(Operand<TInt64> splits, Operand<? extends TNumber> values, Operand<U> weights, Boolean binaryOutput, RaggedCountSparseOutput.Options ... options) {
        return RaggedCountSparseOutput.create(this.scope, splits, values, weights, binaryOutput, options);
    }

    public <T extends TType, U extends TNumber> RaggedCross<T, U> raggedCross(Iterable<Operand<?>> raggedValues, Iterable<Operand<?>> raggedRowSplits, Iterable<Operand<TInt64>> sparseIndices, Iterable<Operand<?>> sparseValues, Iterable<Operand<TInt64>> sparseShape, Iterable<Operand<?>> denseInputs, String inputOrder, Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outValuesType, Class<U> outRowSplitsType) {
        return RaggedCross.create(this.scope, raggedValues, raggedRowSplits, sparseIndices, sparseValues, sparseShape, denseInputs, inputOrder, hashedOutput, numBuckets, hashKey, outValuesType, outRowSplitsType);
    }

    public <T extends TType> RaggedFillEmptyRows<T> raggedFillEmptyRows(Operand<TInt64> valueRowids, Operand<T> values, Operand<TInt64> nrows, Operand<T> defaultValue) {
        return RaggedFillEmptyRows.create(this.scope, valueRowids, values, nrows, defaultValue);
    }

    public <T extends TType> RaggedFillEmptyRowsGrad<T> raggedFillEmptyRowsGrad(Operand<TInt64> reverseIndexMap, Operand<T> gradValues) {
        return RaggedFillEmptyRowsGrad.create(this.scope, reverseIndexMap, gradValues);
    }

    public <T extends TNumber, U extends TType> RaggedGather<T, U> raggedGather(Iterable<Operand<T>> paramsNestedSplits, Operand<U> paramsDenseValues, Operand<? extends TNumber> indices, Long OUTPUTRAGGEDRANK) {
        return RaggedGather.create(this.scope, paramsNestedSplits, paramsDenseValues, indices, OUTPUTRAGGEDRANK);
    }

    public <T extends TNumber> RaggedRange<TInt64, T> raggedRange(Operand<T> starts, Operand<T> limits, Operand<T> deltas) {
        return RaggedRange.create(this.scope, starts, limits, deltas);
    }

    public <U extends TNumber, T extends TNumber> RaggedRange<U, T> raggedRange(Operand<T> starts, Operand<T> limits, Operand<T> deltas, Class<U> Tsplits) {
        return RaggedRange.create(this.scope, starts, limits, deltas, Tsplits);
    }

    public <U extends TType> RaggedTensorFromVariant<TInt64, U> raggedTensorFromVariant(Operand<? extends TType> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, Class<U> Tvalues) {
        return RaggedTensorFromVariant.create(this.scope, encodedRagged, inputRaggedRank, outputRaggedRank, Tvalues);
    }

    public <T extends TNumber, U extends TType> RaggedTensorFromVariant<T, U> raggedTensorFromVariant(Operand<? extends TType> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, Class<U> Tvalues, Class<T> Tsplits) {
        return RaggedTensorFromVariant.create(this.scope, encodedRagged, inputRaggedRank, outputRaggedRank, Tvalues, Tsplits);
    }

    public <U extends TType> RaggedTensorToSparse<U> raggedTensorToSparse(Iterable<Operand<? extends TNumber>> rtNestedSplits, Operand<U> rtDenseValues) {
        return RaggedTensorToSparse.create(this.scope, rtNestedSplits, rtDenseValues);
    }

    public <U extends TType> RaggedTensorToTensor<U> raggedTensorToTensor(Operand<? extends TNumber> shape, Operand<U> values, Operand<U> defaultValue, Iterable<Operand<? extends TNumber>> rowPartitionTensors, List<String> rowPartitionTypes) {
        return RaggedTensorToTensor.create(this.scope, shape, values, defaultValue, rowPartitionTensors, rowPartitionTypes);
    }

    public RaggedTensorToVariant raggedTensorToVariant(Iterable<Operand<? extends TNumber>> rtNestedSplits, Operand<? extends TType> rtDenseValues, Boolean batchedInput) {
        return RaggedTensorToVariant.create(this.scope, rtNestedSplits, rtDenseValues, batchedInput);
    }

    public <U extends TType> RaggedTensorToVariantGradient<U> raggedTensorToVariantGradient(Operand<? extends TType> encodedRaggedGrad, Operand<? extends TNumber> rowSplits, Operand<TInt32> denseValuesShape, Class<U> Tvalues) {
        return RaggedTensorToVariantGradient.create(this.scope, encodedRaggedGrad, rowSplits, denseValuesShape, Tvalues);
    }

    public final Ops ops() {
        return this.ops;
    }
}

