/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.linalg.sparse.CSRSparseMatrixComponents;
import org.tensorflow.op.linalg.sparse.CSRSparseMatrixToDense;
import org.tensorflow.op.linalg.sparse.CSRSparseMatrixToSparseTensor;
import org.tensorflow.op.linalg.sparse.DenseToCSRSparseMatrix;
import org.tensorflow.op.linalg.sparse.SparseMatrixAdd;
import org.tensorflow.op.linalg.sparse.SparseMatrixMatMul;
import org.tensorflow.op.linalg.sparse.SparseMatrixMul;
import org.tensorflow.op.linalg.sparse.SparseMatrixNNZ;
import org.tensorflow.op.linalg.sparse.SparseMatrixOrderingAMD;
import org.tensorflow.op.linalg.sparse.SparseMatrixSoftmax;
import org.tensorflow.op.linalg.sparse.SparseMatrixSoftmaxGrad;
import org.tensorflow.op.linalg.sparse.SparseMatrixSparseCholesky;
import org.tensorflow.op.linalg.sparse.SparseMatrixSparseMatMul;
import org.tensorflow.op.linalg.sparse.SparseMatrixTranspose;
import org.tensorflow.op.linalg.sparse.SparseMatrixZeros;
import org.tensorflow.op.linalg.sparse.SparseTensorToCSRSparseMatrix;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class LinalgSparseOps {
    private final Scope scope;
    private final Ops ops;

    LinalgSparseOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TType> CSRSparseMatrixComponents<T> cSRSparseMatrixComponents(Operand<? extends TType> csrSparseMatrix, Operand<TInt32> index, Class<T> type) {
        return CSRSparseMatrixComponents.create(this.scope, csrSparseMatrix, index, type);
    }

    public <T extends TType> CSRSparseMatrixToDense<T> cSRSparseMatrixToDense(Operand<? extends TType> sparseInput, Class<T> type) {
        return CSRSparseMatrixToDense.create(this.scope, sparseInput, type);
    }

    public <T extends TType> CSRSparseMatrixToSparseTensor<T> cSRSparseMatrixToSparseTensor(Operand<? extends TType> sparseMatrix, Class<T> type) {
        return CSRSparseMatrixToSparseTensor.create(this.scope, sparseMatrix, type);
    }

    public DenseToCSRSparseMatrix denseToCSRSparseMatrix(Operand<? extends TType> denseInput, Operand<TInt64> indices) {
        return DenseToCSRSparseMatrix.create(this.scope, denseInput, indices);
    }

    public <T extends TType> SparseMatrixAdd sparseMatrixAdd(Operand<? extends TType> a, Operand<? extends TType> b, Operand<T> alpha, Operand<T> beta) {
        return SparseMatrixAdd.create(this.scope, a, b, alpha, beta);
    }

    public <T extends TType> SparseMatrixMatMul<T> sparseMatrixMatMul(Operand<? extends TType> a, Operand<T> b, SparseMatrixMatMul.Options ... options) {
        return SparseMatrixMatMul.create(this.scope, a, b, options);
    }

    public SparseMatrixMul sparseMatrixMul(Operand<? extends TType> a, Operand<? extends TType> b) {
        return SparseMatrixMul.create(this.scope, a, b);
    }

    public SparseMatrixNNZ sparseMatrixNNZ(Operand<? extends TType> sparseMatrix) {
        return SparseMatrixNNZ.create(this.scope, sparseMatrix);
    }

    public SparseMatrixOrderingAMD sparseMatrixOrderingAMD(Operand<? extends TType> input) {
        return SparseMatrixOrderingAMD.create(this.scope, input);
    }

    public <T extends TNumber> SparseMatrixSoftmax sparseMatrixSoftmax(Operand<? extends TType> logits, Class<T> type) {
        return SparseMatrixSoftmax.create(this.scope, logits, type);
    }

    public <T extends TNumber> SparseMatrixSoftmaxGrad sparseMatrixSoftmaxGrad(Operand<? extends TType> softmax, Operand<? extends TType> gradSoftmax, Class<T> type) {
        return SparseMatrixSoftmaxGrad.create(this.scope, softmax, gradSoftmax, type);
    }

    public <T extends TType> SparseMatrixSparseCholesky sparseMatrixSparseCholesky(Operand<? extends TType> input, Operand<TInt32> permutation, Class<T> type) {
        return SparseMatrixSparseCholesky.create(this.scope, input, permutation, type);
    }

    public <T extends TType> SparseMatrixSparseMatMul sparseMatrixSparseMatMul(Operand<? extends TType> a, Operand<? extends TType> b, Class<T> type, SparseMatrixSparseMatMul.Options ... options) {
        return SparseMatrixSparseMatMul.create(this.scope, a, b, type, options);
    }

    public <T extends TType> SparseMatrixTranspose sparseMatrixTranspose(Operand<? extends TType> input, Class<T> type, SparseMatrixTranspose.Options ... options) {
        return SparseMatrixTranspose.create(this.scope, input, type, options);
    }

    public <T extends TType> SparseMatrixZeros sparseMatrixZeros(Operand<TInt64> denseShape, Class<T> type) {
        return SparseMatrixZeros.create(this.scope, denseShape, type);
    }

    public SparseTensorToCSRSparseMatrix sparseTensorToCSRSparseMatrix(Operand<TInt64> indices, Operand<? extends TType> values, Operand<TInt64> denseShape) {
        return SparseTensorToCSRSparseMatrix.create(this.scope, indices, values, denseShape);
    }

    public final Ops ops() {
        return this.ops;
    }
}

