/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sequence;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.tensorflow.ndarray.IllegalRankException;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArraySequence;
import org.tensorflow.ndarray.impl.AbstractNdArray;

public final class SingleElementSequence<T, U extends NdArray<T>>
implements NdArraySequence<U> {
    private final AbstractNdArray<T, U> ndArray;

    public SingleElementSequence(AbstractNdArray<T, U> ndArray) {
        this.ndArray = ndArray;
    }

    @Override
    public Iterator<U> iterator() {
        return new Iterator<U>(){
            private U element;
            {
                this.element = SingleElementSequence.this.ndArray;
            }

            @Override
            public boolean hasNext() {
                return this.element != null;
            }

            @Override
            public U next() {
                Object ret = this.element;
                this.element = null;
                return ret;
            }
        };
    }

    @Override
    public NdArraySequence<U> asSlices() {
        return this;
    }

    @Override
    public void forEachIndexed(BiConsumer<long[], U> consumer) {
        throw new IllegalRankException("Single element has no coordinates to iterate on, use forEach()");
    }
}

