/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.fast.tests;

import com.github.mrpowers.spark.fast.tests.DataFramePrettyPrint$;
import com.github.mrpowers.spark.fast.tests.DatasetComparer;
import com.github.mrpowers.spark.fast.tests.DatasetComparerLike$;
import com.github.mrpowers.spark.fast.tests.DatasetContentMismatch;
import com.github.mrpowers.spark.fast.tests.DatasetCountMismatch;
import com.github.mrpowers.spark.fast.tests.DatasetSchemaMismatch;
import com.github.mrpowers.spark.fast.tests.RddHelpers$;
import com.github.mrpowers.spark.fast.tests.RowComparer$;
import com.github.mrpowers.spark.fast.tests.SchemaComparer$;
import com.github.mrpowers.spark.fast.tests.ufansi.Color$;
import com.github.mrpowers.spark.fast.tests.ufansi.Str;
import com.github.mrpowers.spark.fast.tests.ufansi.Str$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class DatasetComparer$class {
    private static String schemaMismatchMessage(DatasetComparer $this, Dataset actualDS, Dataset expectedDS) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nActual Schema:\n", "\nExpected Schema:\n", "\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actualDS.schema(), expectedDS.schema()}));
    }

    private static String countMismatchMessage(DatasetComparer $this, long actualCount, long expectedCount) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nActual DataFrame Row Count: '", "'\nExpected DataFrame Row Count: '", "'\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)actualCount), BoxesRunTime.boxToLong((long)expectedCount)}));
    }

    private static String betterContentMismatchMessage(DatasetComparer $this, Object a, Object e) {
        return new StringBuilder().append((Object)"\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(a).zip((GenIterable)Predef$.MODULE$.genericWrapArray(e), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Str apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object r2;
                    Object r1 = tuple2._1();
                    Str str = r1.equals(r2 = tuple2._2()) ? Color$.MODULE$.Blue().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r1, r2})))) : Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r1, r2}))));
                    return str;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Str.class)))).mkString("\n")).toString();
    }

    private static String basicMismatchMessage(DatasetComparer $this, Dataset actualDS, Dataset expectedDS) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nActual DataFrame Content:\n", "\nExpected DataFrame Content:\n", "\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataFramePrettyPrint$.MODULE$.showString((Dataset<Row>)actualDS.toDF(), 10, DataFramePrettyPrint$.MODULE$.showString$default$3()), DataFramePrettyPrint$.MODULE$.showString((Dataset<Row>)expectedDS.toDF(), 10, DataFramePrettyPrint$.MODULE$.showString$default$3())}));
    }

    public static void assertSmallDatasetEquality(DatasetComparer $this, Dataset actualDS, Dataset expectedDS, boolean ignoreNullable, boolean orderedComparison) {
        block8: {
            Object e;
            Object a;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            block6: {
                                if (!ignoreNullable) break block6;
                                if (!SchemaComparer$.MODULE$.equals(actualDS.schema(), expectedDS.schema(), true)) {
                                    throw new DatasetSchemaMismatch(DatasetComparer$class.schemaMismatchMessage($this, actualDS, expectedDS));
                                }
                                break block7;
                            }
                            if (!actualDS.schema().equals((Object)expectedDS.schema())) break block8;
                        }
                        if (!orderedComparison) break block9;
                        Object a2 = actualDS.collect();
                        Object e2 = expectedDS.collect();
                        if (!Predef$.MODULE$.genericArrayOps(a2).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(e2))) {
                            throw new DatasetContentMismatch(DatasetComparer$class.betterContentMismatchMessage($this, a2, e2));
                        }
                        break block10;
                    }
                    a = $this.defaultSortDataset(actualDS).collect();
                    e = $this.defaultSortDataset(expectedDS).collect();
                    if (!Predef$.MODULE$.genericArrayOps(a).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(e))) break block11;
                }
                return;
            }
            throw new DatasetContentMismatch(DatasetComparer$class.betterContentMismatchMessage($this, a, e));
        }
        throw new DatasetSchemaMismatch(DatasetComparer$class.schemaMismatchMessage($this, actualDS, expectedDS));
    }

    public static boolean assertSmallDatasetEquality$default$3(DatasetComparer $this) {
        return false;
    }

    public static boolean assertSmallDatasetEquality$default$4(DatasetComparer $this) {
        return true;
    }

    public static Dataset defaultSortDataset(DatasetComparer $this, Dataset ds) {
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])ds.columns()).sorted((Ordering)Ordering.String$.MODULE$);
        Column[] cols = (Column[])Predef$.MODULE$.refArrayOps((Object[])colNames).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return ds.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    /*
     * WARNING - void declaration
     */
    public static void assertLargeDatasetEquality(DatasetComparer $this, Dataset actualDS, Dataset expectedDS, Function2 equals2, ClassTag evidence$1) {
        if (actualDS.schema().equals((Object)expectedDS.schema())) {
            void var8_6;
            void var6_5;
            actualDS.rdd().cache();
            expectedDS.rdd().cache();
            long actualCount = actualDS.rdd().count();
            long expectedCount = expectedDS.rdd().count();
            if (actualCount != expectedCount) {
                throw new DatasetCountMismatch(DatasetComparer$class.countMismatchMessage($this, actualCount, expectedCount));
            }
            RDD expectedIndexValue = RddHelpers$.MODULE$.zipWithIndex(actualDS.rdd());
            RDD resultIndexValue = RddHelpers$.MODULE$.zipWithIndex(expectedDS.rdd());
            RDD unequalRDD = RDD$.MODULE$.rddToPairRDDFunctions(expectedIndexValue, ClassTag$.MODULE$.Long(), evidence$1, (Ordering)Ordering.Long$.MODULE$).join(resultIndexValue).filter((Function1)new Serializable($this, equals2){
                public static final long serialVersionUID = 0L;
                private final Function2 equals$1;

                public final boolean apply(Tuple2<Object, Tuple2<T, T>> x0$2) {
                    Tuple2 tuple2;
                    Tuple2<Object, Tuple2<T, T>> tuple22 = x0$2;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Object o2;
                        Object o1 = tuple2._1();
                        boolean bl = !BoxesRunTime.unboxToBoolean((Object)this.equals$1.apply(o1, o2 = tuple2._2()));
                        return bl;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.equals$1 = equals$1;
                }
            });
            int maxUnequalRowsToShow = 10;
            if (unequalRDD.isEmpty()) {
                unequalRDD.take(maxUnequalRowsToShow);
                return;
            }
            throw new DatasetContentMismatch(DatasetComparer$class.countMismatchMessage($this, (long)var6_5, (long)var8_6));
        }
        throw new DatasetSchemaMismatch(DatasetComparer$class.schemaMismatchMessage($this, actualDS, expectedDS));
        finally {
            actualDS.rdd().unpersist(actualDS.rdd().unpersist$default$1());
            expectedDS.rdd().unpersist(expectedDS.rdd().unpersist$default$1());
        }
    }

    public static Function2 assertLargeDatasetEquality$default$3(DatasetComparer $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object o1, Object o2) {
                return DatasetComparerLike$.MODULE$.naiveEquality(o1, o2);
            }
        };
    }

    public static void assertApproximateDataFrameEquality(DatasetComparer $this, Dataset actualDF, Dataset expectedDF, double precision) {
        $this.assertLargeDatasetEquality(actualDF, expectedDF, new Serializable($this, precision){
            public static final long serialVersionUID = 0L;
            private final double precision$1;

            public final boolean apply(Row r1, Row r2) {
                return r1.equals((Object)r2) || RowComparer$.MODULE$.areRowsEqual(r1, r2, this.precision$1);
            }
            {
                this.precision$1 = precision$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public static void $init$(DatasetComparer $this) {
    }
}

