/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Zettabyte
extends StorageUnit<Zettabyte> {
    private static final long serialVersionUID = 8849006574018911826L;

    Zettabyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Zettabyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte valueOf(long numberOfBytes) {
        return Zettabyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte valueOf(@NotNull Long numberOfBytes) {
        return Zettabyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte add(@NotNull BigInteger bytesToAdd) {
        return new Zettabyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte divide(@NotNull BigInteger divisor) {
        return new Zettabyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte multiply(@NotNull BigInteger factor) {
        return new Zettabyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte subtract(long bytesToSubtract) {
        return this.subtract(BigInteger.valueOf(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Zettabyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Zettabyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return this.subtract(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return BYTES_IN_A_ZETTABYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "ZB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::decimalValueOf;
    }
}

