/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.Byte;
import wtf.metio.storageunits.model.Exabyte;
import wtf.metio.storageunits.model.Exbibyte;
import wtf.metio.storageunits.model.FormatUtils;
import wtf.metio.storageunits.model.Gibibyte;
import wtf.metio.storageunits.model.Gigabyte;
import wtf.metio.storageunits.model.Kibibyte;
import wtf.metio.storageunits.model.Kilobyte;
import wtf.metio.storageunits.model.Mebibyte;
import wtf.metio.storageunits.model.Megabyte;
import wtf.metio.storageunits.model.Pebibyte;
import wtf.metio.storageunits.model.Petabyte;
import wtf.metio.storageunits.model.Qubibyte;
import wtf.metio.storageunits.model.Quettabyte;
import wtf.metio.storageunits.model.Robibyte;
import wtf.metio.storageunits.model.Ronnabyte;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.Tebibyte;
import wtf.metio.storageunits.model.Terabyte;
import wtf.metio.storageunits.model.Yobibyte;
import wtf.metio.storageunits.model.Yottabyte;
import wtf.metio.storageunits.model.Zebibyte;
import wtf.metio.storageunits.model.Zettabyte;

public final class StorageUnits {
    private StorageUnits() {
    }

    @CheckReturnValue
    @NotNull
    public static StorageUnit<?> parse(@NotNull String value) {
        String trimmed = value.trim();
        if (trimmed.endsWith("kB")) {
            return StorageUnits.kilobyte(StorageUnits.parseValue(value, "kB"));
        }
        if (trimmed.endsWith("MB")) {
            return StorageUnits.megabyte(StorageUnits.parseValue(value, "MB"));
        }
        if (trimmed.endsWith("GB")) {
            return StorageUnits.gigabyte(StorageUnits.parseValue(value, "GB"));
        }
        if (trimmed.endsWith("TB")) {
            return StorageUnits.terabyte(StorageUnits.parseValue(value, "TB"));
        }
        if (trimmed.endsWith("PB")) {
            return StorageUnits.petabyte(StorageUnits.parseValue(value, "PB"));
        }
        if (trimmed.endsWith("EB")) {
            return StorageUnits.exabyte(StorageUnits.parseValue(value, "EB"));
        }
        if (trimmed.endsWith("ZB")) {
            return StorageUnits.zettabyte(StorageUnits.parseValue(value, "ZB"));
        }
        if (trimmed.endsWith("YB")) {
            return StorageUnits.yottabyte(StorageUnits.parseValue(value, "YB"));
        }
        if (trimmed.endsWith("RB")) {
            return StorageUnits.ronnabyte(StorageUnits.parseValue(value, "RB"));
        }
        if (trimmed.endsWith("QB")) {
            return StorageUnits.quettabyte(StorageUnits.parseValue(value, "QB"));
        }
        if (trimmed.endsWith("KiB")) {
            return StorageUnits.kibibyte(StorageUnits.parseValue(value, "KiB"));
        }
        if (trimmed.endsWith("MiB")) {
            return StorageUnits.mebibyte(StorageUnits.parseValue(value, "MiB"));
        }
        if (trimmed.endsWith("GiB")) {
            return StorageUnits.gibibyte(StorageUnits.parseValue(value, "GiB"));
        }
        if (trimmed.endsWith("TiB")) {
            return StorageUnits.tebibyte(StorageUnits.parseValue(value, "TiB"));
        }
        if (trimmed.endsWith("PiB")) {
            return StorageUnits.pebibyte(StorageUnits.parseValue(value, "PiB"));
        }
        if (trimmed.endsWith("EiB")) {
            return StorageUnits.exbibyte(StorageUnits.parseValue(value, "EiB"));
        }
        if (trimmed.endsWith("ZiB")) {
            return StorageUnits.zebibyte(StorageUnits.parseValue(value, "ZiB"));
        }
        if (trimmed.endsWith("YiB")) {
            return StorageUnits.yobibyte(StorageUnits.parseValue(value, "YiB"));
        }
        if (trimmed.endsWith("RiB")) {
            return StorageUnits.robibyte(StorageUnits.parseValue(value, "RiB"));
        }
        if (trimmed.endsWith("QiB")) {
            return StorageUnits.robibyte(StorageUnits.parseValue(value, "QiB"));
        }
        return StorageUnits.bytes(StorageUnits.parseValue(value, "b"));
    }

    @NotNull
    private static BigInteger parseValue(@NotNull String value, @NotNull String unit) {
        return new BigInteger(value.replace(unit, "").trim());
    }

    @CheckReturnValue
    @NotNull
    public static StorageUnit<?> binaryValueOf(long bytes) {
        return StorageUnits.binaryValueOf(BigInteger.valueOf(bytes));
    }

    @CheckReturnValue
    @NotNull
    public static StorageUnit<?> binaryValueOf(@NotNull BigInteger bytes) {
        BigInteger positiveNumberOfBytes;
        StorageUnit unit = Byte.valueOf(bytes);
        BigInteger bigInteger = positiveNumberOfBytes = bytes.signum() == -1 ? bytes.negate() : bytes;
        if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_KIBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_MEBIBYTE)) {
            unit = unit.asKibibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_MEBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_GIBIBYTE)) {
            unit = unit.asMebibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_GIBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_TEBIBYTE)) {
            unit = unit.asGibibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_TEBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_PEBIBYTE)) {
            unit = unit.asTebibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_PEBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_EXBIBYTE)) {
            unit = unit.asPebibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_EXBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_ZEBIBYTE)) {
            unit = unit.asExbibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_ZEBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_YOBIBYTE)) {
            unit = unit.asZebibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_YOBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_ROBIBYTE)) {
            unit = unit.asYobibyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_ROBIBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_QUBIBYTE)) {
            unit = unit.asRobibyte();
        } else if (StorageUnits.isGreaterThanEquals(positiveNumberOfBytes, StorageUnit.BYTES_IN_A_QUBIBYTE)) {
            unit = unit.asQubibyte();
        }
        return unit;
    }

    @CheckReturnValue
    @NotNull
    public static StorageUnit<?> decimalValueOf(long bytes) {
        return StorageUnits.decimalValueOf(BigInteger.valueOf(bytes));
    }

    @CheckReturnValue
    @NotNull
    public static StorageUnit<?> decimalValueOf(@NotNull BigInteger bytes) {
        BigInteger positiveNumberOfBytes;
        StorageUnit unit = Byte.valueOf(bytes);
        BigInteger bigInteger = positiveNumberOfBytes = bytes.signum() == -1 ? bytes.negate() : bytes;
        if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_KILOBYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_MEGABYTE)) {
            unit = unit.asKilobyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_MEGABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_GIGABYTE)) {
            unit = unit.asMegabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_GIGABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_TERABYTE)) {
            unit = unit.asGigabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_TERABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_PETABYTE)) {
            unit = unit.asTerabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_PETABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_EXABYTE)) {
            unit = unit.asPetabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_EXABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_ZETTABYTE)) {
            unit = unit.asExabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_ZETTABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_YOTTABYTE)) {
            unit = unit.asZettabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_YOTTABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_RONNABYTE)) {
            unit = unit.asYottabyte();
        } else if (StorageUnits.isInBetween(StorageUnit.BYTES_IN_A_RONNABYTE, positiveNumberOfBytes, StorageUnit.BYTES_IN_A_QUETTABYTE)) {
            unit = unit.asRonnabyte();
        } else if (StorageUnits.isGreaterThanEquals(positiveNumberOfBytes, StorageUnit.BYTES_IN_A_QUETTABYTE)) {
            unit = unit.asQuettabyte();
        }
        return unit;
    }

    @CheckReturnValue
    private static boolean isInBetween(BigInteger start, BigInteger value, BigInteger endExclusive) {
        return StorageUnits.isGreaterThanEquals(value, start) && value.compareTo(endExclusive) < 0;
    }

    @CheckReturnValue
    private static boolean isGreaterThanEquals(BigInteger value, BigInteger comparison) {
        return value.compareTo(comparison) >= 0;
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsByte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsByte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsByte(long numberOfBytes) {
        return StorageUnits.formatAsByte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsByte(@NotNull BigInteger numberOfBytes) {
        return numberOfBytes + " B";
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsBinaryUnit((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(long numberOfBytes) {
        return StorageUnits.formatAsBinaryUnit(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsBinaryUnit(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsBinaryUnit((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsBinaryUnit(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsBinaryUnit(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsBinaryUnit((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsBinaryUnit(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsBinaryUnit(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsBinaryUnit((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsBinaryUnit(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsBinaryUnit(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return StorageUnits.binaryValueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsKibibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(long numberOfBytes) {
        return StorageUnits.formatAsKibibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsKibibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKibibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKibibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKibibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKibibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKibibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKibibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsKibibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsKibibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKibibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Kibibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsMebibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(long numberOfBytes) {
        return StorageUnits.formatAsMebibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsMebibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMebibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMebibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMebibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMebibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMebibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMebibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsMebibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsMebibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMebibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Mebibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsGibibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(long numberOfBytes) {
        return StorageUnits.formatAsGibibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsGibibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGibibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGibibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGibibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGibibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGibibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGibibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsGibibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsGibibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGibibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Gibibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsTebibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(long numberOfBytes) {
        return StorageUnits.formatAsTebibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsTebibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTebibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTebibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTebibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTebibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTebibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTebibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsTebibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsTebibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTebibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Tebibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsPebibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(long numberOfBytes) {
        return StorageUnits.formatAsPebibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsPebibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPebibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPebibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPebibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPebibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPebibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPebibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsPebibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsPebibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPebibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Pebibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsExbibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(long numberOfBytes) {
        return StorageUnits.formatAsExbibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsExbibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExbibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExbibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExbibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExbibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExbibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExbibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsExbibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsExbibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExbibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Exbibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsZebibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(long numberOfBytes) {
        return StorageUnits.formatAsZebibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsZebibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZebibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZebibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZebibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZebibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZebibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZebibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsZebibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsZebibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZebibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Zebibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsYobibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(long numberOfBytes) {
        return StorageUnits.formatAsYobibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsYobibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYobibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYobibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYobibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYobibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYobibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYobibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsYobibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsYobibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYobibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Yobibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsRobibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(long numberOfBytes) {
        return StorageUnits.formatAsRobibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsRobibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRobibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRobibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRobibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRobibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRobibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRobibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsRobibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsRobibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRobibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Robibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsQubibyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(long numberOfBytes) {
        return StorageUnits.formatAsQubibyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsQubibyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQubibyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQubibyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQubibyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQubibyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQubibyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQubibyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsQubibyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsQubibyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQubibyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Qubibyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsDecimalUnit((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(long numberOfBytes) {
        return StorageUnits.formatAsDecimalUnit(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsDecimalUnit(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsDecimalUnit((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsDecimalUnit(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsDecimalUnit(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsDecimalUnit((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsDecimalUnit(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsDecimalUnit(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsDecimalUnit((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsDecimalUnit(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsDecimalUnit(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return StorageUnits.decimalValueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsKilobyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(long numberOfBytes) {
        return StorageUnits.formatAsKilobyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsKilobyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKilobyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKilobyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsKilobyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKilobyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKilobyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsKilobyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsKilobyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsKilobyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsKilobyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Kilobyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsMegabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(long numberOfBytes) {
        return StorageUnits.formatAsMegabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsMegabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMegabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMegabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsMegabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMegabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMegabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsMegabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsMegabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsMegabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsMegabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Megabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsGigabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(long numberOfBytes) {
        return StorageUnits.formatAsGigabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsGigabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGigabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGigabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsGigabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGigabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGigabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsGigabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsGigabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsGigabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsGigabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Gigabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsTerabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(long numberOfBytes) {
        return StorageUnits.formatAsTerabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsTerabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTerabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTerabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsTerabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTerabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTerabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsTerabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsTerabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsTerabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsTerabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Terabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsPetabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(long numberOfBytes) {
        return StorageUnits.formatAsPetabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsPetabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPetabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPetabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsPetabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPetabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPetabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsPetabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsPetabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsPetabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsPetabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Petabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsExabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(long numberOfBytes) {
        return StorageUnits.formatAsExabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsExabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsExabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsExabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsExabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsExabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsExabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Exabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsZettabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(long numberOfBytes) {
        return StorageUnits.formatAsZettabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsZettabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZettabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZettabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsZettabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZettabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZettabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsZettabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsZettabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsZettabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsZettabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Zettabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsYottabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(long numberOfBytes) {
        return StorageUnits.formatAsYottabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsYottabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYottabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYottabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYottabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYottabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsYottabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsYottabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsYottabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsYottabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsYottabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Yottabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsRonnabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(long numberOfBytes) {
        return StorageUnits.formatAsRonnabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsRonnabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRonnabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRonnabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRonnabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRonnabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsRonnabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsRonnabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsRonnabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsRonnabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsRonnabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Ronnabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull Long numberOfBytes) {
        return StorageUnits.formatAsQuettabyte((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(long numberOfBytes) {
        return StorageUnits.formatAsQuettabyte(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull BigInteger numberOfBytes) {
        return StorageUnits.formatAsQuettabyte(numberOfBytes, "0.00");
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull Long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQuettabyte((long)numberOfBytes, pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(long numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQuettabyte(BigInteger.valueOf(numberOfBytes), pattern);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQuettabyte(numberOfBytes, FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull Long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQuettabyte((long)numberOfBytes, pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(long numberOfBytes, @NotNull String pattern, @NotNull Locale locale) {
        return StorageUnits.formatAsQuettabyte(BigInteger.valueOf(numberOfBytes), pattern, locale);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull BigInteger numberOfBytes, @NotNull String pattern) {
        return StorageUnits.formatAsQuettabyte(numberOfBytes, (Format)new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull Long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsQuettabyte((long)numberOfBytes, format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(long numberOfBytes, @NotNull Format format) {
        return StorageUnits.formatAsQuettabyte(BigInteger.valueOf(numberOfBytes), format);
    }

    @CheckReturnValue
    @NotNull
    public static String formatAsQuettabyte(@NotNull BigInteger numberOfBytes, @NotNull Format format) {
        return Quettabyte.valueOf(numberOfBytes).toString(format);
    }

    @CheckReturnValue
    @NotNull
    public static Byte bytes(@NotNull Long numberOfBytes) {
        return StorageUnits.bytes((long)numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Byte bytes(long numberOfBytes) {
        return StorageUnits.bytes(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Byte bytes(@NotNull BigInteger numberOfBytes) {
        return new Byte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Kibibyte kibibyte(@NotNull Long numberOfKibibytes) {
        return StorageUnits.kibibyte((long)numberOfKibibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Kibibyte kibibyte(long numberOfKibibytes) {
        return StorageUnits.kibibyte(BigInteger.valueOf(numberOfKibibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Kibibyte kibibyte(@NotNull BigInteger numberOfKibibytes) {
        return new Kibibyte(StorageUnit.BYTES_IN_A_KIBIBYTE.multiply(numberOfKibibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Mebibyte mebibyte(@NotNull Long numberOfMebibytes) {
        return StorageUnits.mebibyte((long)numberOfMebibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Mebibyte mebibyte(long numberOfMebibytes) {
        return StorageUnits.mebibyte(BigInteger.valueOf(numberOfMebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Mebibyte mebibyte(@NotNull BigInteger numberOfMebibytes) {
        return new Mebibyte(StorageUnit.BYTES_IN_A_MEBIBYTE.multiply(numberOfMebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Gibibyte gibibyte(@NotNull Long numberOfGibibytes) {
        return StorageUnits.gibibyte((long)numberOfGibibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Gibibyte gibibyte(long numberOfGibibytes) {
        return StorageUnits.gibibyte(BigInteger.valueOf(numberOfGibibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Gibibyte gibibyte(@NotNull BigInteger numberOfGibibytes) {
        return new Gibibyte(StorageUnit.BYTES_IN_A_GIBIBYTE.multiply(numberOfGibibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Tebibyte tebibyte(@NotNull Long numberOfTebibytes) {
        return StorageUnits.tebibyte((long)numberOfTebibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Tebibyte tebibyte(long numberOfTebibytes) {
        return StorageUnits.tebibyte(BigInteger.valueOf(numberOfTebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Tebibyte tebibyte(@NotNull BigInteger numberOfTebibytes) {
        return new Tebibyte(StorageUnit.BYTES_IN_A_TEBIBYTE.multiply(numberOfTebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte pebibyte(@NotNull Long numberOfPebibytes) {
        return StorageUnits.pebibyte((long)numberOfPebibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte pebibyte(long numberOfPebibytes) {
        return StorageUnits.pebibyte(BigInteger.valueOf(numberOfPebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte pebibyte(@NotNull BigInteger numberOfPebibytes) {
        return new Pebibyte(StorageUnit.BYTES_IN_A_PEBIBYTE.multiply(numberOfPebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte exbibyte(@NotNull Long numberOfExbibytes) {
        return StorageUnits.exbibyte((long)numberOfExbibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte exbibyte(long numberOfExbibytes) {
        return StorageUnits.exbibyte(BigInteger.valueOf(numberOfExbibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte exbibyte(@NotNull BigInteger numberOfExbibytes) {
        return new Exbibyte(StorageUnit.BYTES_IN_A_EXBIBYTE.multiply(numberOfExbibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Zebibyte zebibyte(@NotNull Long numberOfZebibytes) {
        return StorageUnits.zebibyte((long)numberOfZebibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Zebibyte zebibyte(long numberOfZebibytes) {
        return StorageUnits.zebibyte(BigInteger.valueOf(numberOfZebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Zebibyte zebibyte(@NotNull BigInteger numberOfZebibytes) {
        return new Zebibyte(StorageUnit.BYTES_IN_A_ZEBIBYTE.multiply(numberOfZebibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Yobibyte yobibyte(@NotNull Long numberOfYobibytes) {
        return StorageUnits.yobibyte((long)numberOfYobibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Yobibyte yobibyte(long numberOfYobibytes) {
        return StorageUnits.yobibyte(BigInteger.valueOf(numberOfYobibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Yobibyte yobibyte(@NotNull BigInteger numberOfYobibytes) {
        return new Yobibyte(StorageUnit.BYTES_IN_A_YOBIBYTE.multiply(numberOfYobibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Robibyte robibyte(@NotNull Long numberOfRobibytes) {
        return StorageUnits.robibyte((long)numberOfRobibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Robibyte robibyte(long numberOfRobibytes) {
        return StorageUnits.robibyte(BigInteger.valueOf(numberOfRobibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Robibyte robibyte(@NotNull BigInteger numberOfRobibytes) {
        return new Robibyte(StorageUnit.BYTES_IN_A_ROBIBYTE.multiply(numberOfRobibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Qubibyte qubibyte(@NotNull Long numberOfQubibytes) {
        return StorageUnits.qubibyte((long)numberOfQubibytes);
    }

    @CheckReturnValue
    @NotNull
    public static Qubibyte qubibyte(long numberOfQubibytes) {
        return StorageUnits.qubibyte(BigInteger.valueOf(numberOfQubibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Qubibyte qubibyte(@NotNull BigInteger numberOfQubibytes) {
        return new Qubibyte(StorageUnit.BYTES_IN_A_QUBIBYTE.multiply(numberOfQubibytes));
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte kilobyte(@NotNull Long numberOfKilobytes) {
        return StorageUnits.kilobyte((long)numberOfKilobytes);
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte kilobyte(long numberOfKilobytes) {
        return StorageUnits.kilobyte(BigInteger.valueOf(numberOfKilobytes));
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte kilobyte(@NotNull BigInteger numberOfKilobytes) {
        return new Kilobyte(StorageUnit.BYTES_IN_A_KILOBYTE.multiply(numberOfKilobytes));
    }

    @CheckReturnValue
    @NotNull
    public static Megabyte megabyte(@NotNull Long numberOfMegabytes) {
        return StorageUnits.megabyte((long)numberOfMegabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Megabyte megabyte(long numberOfMegabytes) {
        return StorageUnits.megabyte(BigInteger.valueOf(numberOfMegabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Megabyte megabyte(@NotNull BigInteger numberOfMegabytes) {
        return new Megabyte(StorageUnit.BYTES_IN_A_MEGABYTE.multiply(numberOfMegabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte gigabyte(@NotNull Long numberOfGigabytes) {
        return StorageUnits.gigabyte((long)numberOfGigabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte gigabyte(long numberOfGigabytes) {
        return StorageUnits.gigabyte(BigInteger.valueOf(numberOfGigabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte gigabyte(@NotNull BigInteger numberOfGigabytes) {
        return new Gigabyte(StorageUnit.BYTES_IN_A_GIGABYTE.multiply(numberOfGigabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Terabyte terabyte(@NotNull Long numberOfTerabytes) {
        return StorageUnits.terabyte((long)numberOfTerabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Terabyte terabyte(long numberOfTerabytes) {
        return StorageUnits.terabyte(BigInteger.valueOf(numberOfTerabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Terabyte terabyte(@NotNull BigInteger numberOfTerabytes) {
        return new Terabyte(StorageUnit.BYTES_IN_A_TERABYTE.multiply(numberOfTerabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte petabyte(@NotNull Long numberOfPetabytes) {
        return StorageUnits.petabyte((long)numberOfPetabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte petabyte(long numberOfPetabytes) {
        return StorageUnits.petabyte(BigInteger.valueOf(numberOfPetabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte petabyte(@NotNull BigInteger numberOfPetabytes) {
        return new Petabyte(StorageUnit.BYTES_IN_A_PETABYTE.multiply(numberOfPetabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte exabyte(@NotNull Long numberOfExabytes) {
        return StorageUnits.exabyte((long)numberOfExabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte exabyte(long numberOfExabytes) {
        return StorageUnits.exabyte(BigInteger.valueOf(numberOfExabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte exabyte(@NotNull BigInteger numberOfExabytes) {
        return new Exabyte(StorageUnit.BYTES_IN_A_EXABYTE.multiply(numberOfExabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte zettabyte(@NotNull Long numberOfZettabytes) {
        return StorageUnits.zettabyte((long)numberOfZettabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte zettabyte(long numberOfZettabytes) {
        return StorageUnits.zettabyte(BigInteger.valueOf(numberOfZettabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Zettabyte zettabyte(@NotNull BigInteger numberOfZettabytes) {
        return new Zettabyte(StorageUnit.BYTES_IN_A_ZETTABYTE.multiply(numberOfZettabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Yottabyte yottabyte(@NotNull Long numberOfYottabytes) {
        return StorageUnits.yottabyte((long)numberOfYottabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Yottabyte yottabyte(long numberOfYottabytes) {
        return StorageUnits.yottabyte(BigInteger.valueOf(numberOfYottabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Yottabyte yottabyte(@NotNull BigInteger numberOfYottabytes) {
        return new Yottabyte(StorageUnit.BYTES_IN_A_YOTTABYTE.multiply(numberOfYottabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Ronnabyte ronnabyte(@NotNull Long numberOfRonnabytes) {
        return StorageUnits.ronnabyte((long)numberOfRonnabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Ronnabyte ronnabyte(long numberOfRonnabytes) {
        return StorageUnits.ronnabyte(BigInteger.valueOf(numberOfRonnabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Ronnabyte ronnabyte(@NotNull BigInteger numberOfRonnabytes) {
        return new Ronnabyte(StorageUnit.BYTES_IN_A_RONNABYTE.multiply(numberOfRonnabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Quettabyte quettabyte(@NotNull Long numberOfQuettabytes) {
        return StorageUnits.quettabyte((long)numberOfQuettabytes);
    }

    @CheckReturnValue
    @NotNull
    public static Quettabyte quettabyte(long numberOfQuettabytes) {
        return StorageUnits.quettabyte(BigInteger.valueOf(numberOfQuettabytes));
    }

    @CheckReturnValue
    @NotNull
    public static Quettabyte quettabyte(@NotNull BigInteger numberOfQuettabytes) {
        return new Quettabyte(StorageUnit.BYTES_IN_A_QUETTABYTE.multiply(numberOfQuettabytes));
    }
}

