/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.Byte;
import wtf.metio.storageunits.model.Exabyte;
import wtf.metio.storageunits.model.Exbibyte;
import wtf.metio.storageunits.model.FormatUtils;
import wtf.metio.storageunits.model.Gibibyte;
import wtf.metio.storageunits.model.Gigabyte;
import wtf.metio.storageunits.model.Kibibyte;
import wtf.metio.storageunits.model.Kilobyte;
import wtf.metio.storageunits.model.Mebibyte;
import wtf.metio.storageunits.model.Megabyte;
import wtf.metio.storageunits.model.Pebibyte;
import wtf.metio.storageunits.model.Petabyte;
import wtf.metio.storageunits.model.Qubibyte;
import wtf.metio.storageunits.model.Quettabyte;
import wtf.metio.storageunits.model.Robibyte;
import wtf.metio.storageunits.model.Ronnabyte;
import wtf.metio.storageunits.model.StorageUnits;
import wtf.metio.storageunits.model.Tebibyte;
import wtf.metio.storageunits.model.Terabyte;
import wtf.metio.storageunits.model.Yobibyte;
import wtf.metio.storageunits.model.Yottabyte;
import wtf.metio.storageunits.model.Zebibyte;
import wtf.metio.storageunits.model.Zettabyte;

public abstract class StorageUnit<T extends StorageUnit<T>>
extends Number
implements Comparable<StorageUnit<?>> {
    private static final long serialVersionUID = -7344790980741118949L;
    private static final int DEFAULT_SCALE = 24;
    @NotNull
    static final String DEFAULT_FORMAT_PATTERN = "0.00";
    @NotNull
    static final BigInteger BINARY_UNIT_BASE = BigInteger.valueOf(1024L);
    @NotNull
    static final BigInteger BYTES_IN_A_KIBIBYTE = BigInteger.ONE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_MEBIBYTE = BYTES_IN_A_KIBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_GIBIBYTE = BYTES_IN_A_MEBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_TEBIBYTE = BYTES_IN_A_GIBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_PEBIBYTE = BYTES_IN_A_TEBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_EXBIBYTE = BYTES_IN_A_PEBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_ZEBIBYTE = BYTES_IN_A_EXBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_YOBIBYTE = BYTES_IN_A_ZEBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_ROBIBYTE = BYTES_IN_A_YOBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_QUBIBYTE = BYTES_IN_A_ROBIBYTE.multiply(BINARY_UNIT_BASE);
    @NotNull
    static final BigInteger DECIMAL_UNIT_BASE = BigInteger.valueOf(1000L);
    @NotNull
    static final BigInteger BYTES_IN_A_KILOBYTE = BigInteger.ONE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_MEGABYTE = BYTES_IN_A_KILOBYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_GIGABYTE = BYTES_IN_A_MEGABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_TERABYTE = BYTES_IN_A_GIGABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_PETABYTE = BYTES_IN_A_TERABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_EXABYTE = BYTES_IN_A_PETABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_ZETTABYTE = BYTES_IN_A_EXABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_YOTTABYTE = BYTES_IN_A_ZETTABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_RONNABYTE = BYTES_IN_A_YOTTABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    static final BigInteger BYTES_IN_A_QUETTABYTE = BYTES_IN_A_RONNABYTE.multiply(DECIMAL_UNIT_BASE);
    @NotNull
    protected final BigInteger bytes;

    protected StorageUnit(@NotNull BigInteger numberOfBytes) {
        this.bytes = numberOfBytes;
    }

    @CheckReturnValue
    @NotNull
    public final StorageUnit<?> asBestMatchingBinaryUnit() {
        return StorageUnits.binaryValueOf(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final StorageUnit<?> asBestMatchingDecimalUnit() {
        return StorageUnits.decimalValueOf(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final StorageUnit<?> asBestMatchingUnit() {
        return this.converter().apply(this.bytes);
    }

    @NotNull
    protected abstract @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter();

    @CheckReturnValue
    @NotNull
    public final Byte asByte() {
        return new Byte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Kibibyte asKibibyte() {
        return new Kibibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Mebibyte asMebibyte() {
        return new Mebibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Gibibyte asGibibyte() {
        return new Gibibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Tebibyte asTebibyte() {
        return new Tebibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Pebibyte asPebibyte() {
        return new Pebibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Exbibyte asExbibyte() {
        return new Exbibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Zebibyte asZebibyte() {
        return new Zebibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Yobibyte asYobibyte() {
        return new Yobibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Robibyte asRobibyte() {
        return new Robibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Qubibyte asQubibyte() {
        return new Qubibyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Kilobyte asKilobyte() {
        return new Kilobyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Megabyte asMegabyte() {
        return new Megabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Gigabyte asGigabyte() {
        return new Gigabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Terabyte asTerabyte() {
        return new Terabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Petabyte asPetabyte() {
        return new Petabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Exabyte asExabyte() {
        return new Exabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Zettabyte asZettabyte() {
        return new Zettabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Yottabyte asYottabyte() {
        return new Yottabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Ronnabyte asRonnabyte() {
        return new Ronnabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final Quettabyte asQuettabyte() {
        return new Quettabyte(this.bytes);
    }

    @CheckReturnValue
    @NotNull
    public final BigInteger inByte() {
        return this.bytes;
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inKibibyte() {
        return this.calculate(BYTES_IN_A_KIBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inMebibyte() {
        return this.calculate(BYTES_IN_A_MEBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inGibibyte() {
        return this.calculate(BYTES_IN_A_GIBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inTebibyte() {
        return this.calculate(BYTES_IN_A_TEBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inPebibyte() {
        return this.calculate(BYTES_IN_A_PEBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inExbibyte() {
        return this.calculate(BYTES_IN_A_EXBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inZebibyte() {
        return this.calculate(BYTES_IN_A_ZEBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inYobibyte() {
        return this.calculate(BYTES_IN_A_YOBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inRobibyte() {
        return this.calculate(BYTES_IN_A_ROBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inQubibyte() {
        return this.calculate(BYTES_IN_A_QUBIBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inKilobyte() {
        return this.calculate(BYTES_IN_A_KILOBYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inMegabyte() {
        return this.calculate(BYTES_IN_A_MEGABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inGigabyte() {
        return this.calculate(BYTES_IN_A_GIGABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inTerabyte() {
        return this.calculate(BYTES_IN_A_TERABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inPetabyte() {
        return this.calculate(BYTES_IN_A_PETABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inExabyte() {
        return this.calculate(BYTES_IN_A_EXABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inZettabyte() {
        return this.calculate(BYTES_IN_A_ZETTABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inYottabyte() {
        return this.calculate(BYTES_IN_A_YOTTABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inRonnabyte() {
        return this.calculate(BYTES_IN_A_RONNABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final BigDecimal inQuettabyte() {
        return this.calculate(BYTES_IN_A_QUETTABYTE);
    }

    @CheckReturnValue
    @NotNull
    public final String toString() {
        return this.toString(DEFAULT_FORMAT_PATTERN);
    }

    @CheckReturnValue
    @NotNull
    public final String toString(String pattern) {
        return this.toString(new DecimalFormat(pattern));
    }

    @CheckReturnValue
    @NotNull
    public final String toString(String pattern, Locale locale) {
        return this.toString(FormatUtils.asFormat(pattern, locale));
    }

    @CheckReturnValue
    @NotNull
    public final String toString(Format format) {
        BigDecimal amount = this.calculate(this.getNumberOfBytesPerUnit());
        String formattedAmount = format.format(amount);
        return String.format("%s %s", formattedAmount, this.getSymbol());
    }

    @CheckReturnValue
    @NotNull
    private BigDecimal calculate(BigInteger base) {
        return new BigDecimal(this.bytes).divide(new BigDecimal(base), 24, RoundingMode.CEILING);
    }

    public final int hashCode() {
        return Objects.hashCode(this.bytes);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof StorageUnit) {
            StorageUnit other = (StorageUnit)obj;
            return Objects.equals(this.bytes, other.bytes);
        }
        return false;
    }

    @Override
    public final int compareTo(StorageUnit<?> o) {
        return this.bytes.compareTo(o.bytes);
    }

    @Override
    public final double doubleValue() {
        return this.bytes.doubleValue();
    }

    @Override
    public final float floatValue() {
        return this.bytes.floatValue();
    }

    @Override
    public final int intValue() {
        return this.bytes.intValue();
    }

    @Override
    public final long longValue() {
        return this.bytes.longValue();
    }

    @NotNull
    public abstract T add(long var1);

    @NotNull
    public abstract T add(@NotNull BigInteger var1);

    @NotNull
    public abstract T add(@NotNull StorageUnit<?> var1);

    @NotNull
    public abstract T divide(long var1);

    @NotNull
    public abstract T divide(@NotNull BigInteger var1);

    @NotNull
    public abstract T multiply(long var1);

    @NotNull
    public abstract T multiply(@NotNull BigInteger var1);

    @NotNull
    public abstract T subtract(long var1);

    @NotNull
    public abstract T subtract(@NotNull BigInteger var1);

    @NotNull
    public abstract T subtract(@NotNull StorageUnit<?> var1);

    @NotNull
    protected abstract BigInteger getNumberOfBytesPerUnit();

    @NotNull
    protected abstract String getSymbol();
}

