/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Petabyte
extends StorageUnit<Petabyte> {
    private static final long serialVersionUID = 5889808368085688387L;

    Petabyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Petabyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte valueOf(long numberOfBytes) {
        return Petabyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Petabyte valueOf(@NotNull Long numberOfBytes) {
        return Petabyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte add(@NotNull BigInteger bytesToAdd) {
        return new Petabyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte divide(@NotNull BigInteger divisor) {
        return new Petabyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte multiply(@NotNull BigInteger factor) {
        return new Petabyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte subtract(long bytesToSubtract) {
        return this.subtract(BigInteger.valueOf(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Petabyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Petabyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return this.subtract(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return StorageUnit.BYTES_IN_A_PETABYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "PB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::decimalValueOf;
    }
}

