/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Pebibyte
extends StorageUnit<Pebibyte> {
    private static final long serialVersionUID = -6112472064345339882L;

    Pebibyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Pebibyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte valueOf(long numberOfBytes) {
        return Pebibyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Pebibyte valueOf(@NotNull Long numberOfBytes) {
        return Pebibyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte add(@NotNull BigInteger bytesToAdd) {
        return new Pebibyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte divide(@NotNull BigInteger divisor) {
        return new Pebibyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte multiply(@NotNull BigInteger factor) {
        return new Pebibyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte subtract(long bytesToSubtract) {
        return this.subtract(BigInteger.valueOf(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Pebibyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Pebibyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return this.subtract(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return StorageUnit.BYTES_IN_A_PEBIBYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "PiB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::binaryValueOf;
    }
}

