/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Kilobyte
extends StorageUnit<Kilobyte> {
    private static final long serialVersionUID = 6952239416014811456L;

    Kilobyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Kilobyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte valueOf(long numberOfBytes) {
        return Kilobyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Kilobyte valueOf(@NotNull Long numberOfBytes) {
        return Kilobyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte add(@NotNull BigInteger bytesToAdd) {
        return new Kilobyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte divide(@NotNull BigInteger divisor) {
        return new Kilobyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte multiply(@NotNull BigInteger factor) {
        return new Kilobyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte subtract(long bytesToSubtract) {
        return this.subtract(BigInteger.valueOf(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Kilobyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Kilobyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return this.subtract(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return BYTES_IN_A_KILOBYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "kB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::decimalValueOf;
    }
}

