/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Gigabyte
extends StorageUnit<Gigabyte> {
    private static final long serialVersionUID = 7581075190529125530L;

    Gigabyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Gigabyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte valueOf(long numberOfBytes) {
        return Gigabyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Gigabyte valueOf(@NotNull Long numberOfBytes) {
        return Gigabyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte add(@NotNull BigInteger bytesToAdd) {
        return new Gigabyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte divide(@NotNull BigInteger divisor) {
        return new Gigabyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte multiply(@NotNull BigInteger factor) {
        return new Gigabyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte subtract(long bytesToSubtract) {
        return this.subtract(BigInteger.valueOf(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Gigabyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Gigabyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return this.subtract(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return BYTES_IN_A_GIGABYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "GB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::decimalValueOf;
    }
}

