/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Exbibyte
extends StorageUnit<Exbibyte> {
    private static final long serialVersionUID = 5993490571003918471L;

    Exbibyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Exbibyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte valueOf(long numberOfBytes) {
        return Exbibyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exbibyte valueOf(@NotNull Long numberOfBytes) {
        return Exbibyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte add(@NotNull BigInteger bytesToAdd) {
        return new Exbibyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte divide(@NotNull BigInteger divisor) {
        return new Exbibyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte multiply(long factor) {
        return new Exbibyte(this.bytes.multiply(BigInteger.valueOf(factor)));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte multiply(@NotNull BigInteger factor) {
        return new Exbibyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte subtract(long bytesToSubtract) {
        return new Exbibyte(this.bytes.subtract(BigInteger.valueOf(bytesToSubtract)));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Exbibyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exbibyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return new Exbibyte(this.bytes.subtract(storageAmount.bytes));
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return StorageUnit.BYTES_IN_A_EXBIBYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "EiB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::binaryValueOf;
    }
}

