/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Exabyte
extends StorageUnit<Exabyte> {
    private static final long serialVersionUID = 6846441733771841250L;

    Exabyte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Exabyte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte valueOf(long numberOfBytes) {
        return Exabyte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Exabyte valueOf(@NotNull Long numberOfBytes) {
        return Exabyte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte add(@NotNull BigInteger bytesToAdd) {
        return new Exabyte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte divide(@NotNull BigInteger divisor) {
        return new Exabyte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte multiply(long factor) {
        return new Exabyte(this.bytes.multiply(BigInteger.valueOf(factor)));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte multiply(@NotNull BigInteger factor) {
        return new Exabyte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte subtract(long bytesToSubtract) {
        return new Exabyte(this.bytes.subtract(BigInteger.valueOf(bytesToSubtract)));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Exabyte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Exabyte subtract(@NotNull StorageUnit<?> storageAmount) {
        return new Exabyte(this.bytes.subtract(storageAmount.bytes));
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return StorageUnit.BYTES_IN_A_EXABYTE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "EB";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::decimalValueOf;
    }
}

