/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.storageunits.model;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import wtf.metio.storageunits.model.StorageUnit;
import wtf.metio.storageunits.model.StorageUnits;

public final class Byte
extends StorageUnit<Byte> {
    private static final long serialVersionUID = 6952239416014811456L;

    Byte(@NotNull BigInteger numberOfBytes) {
        super(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Byte valueOf(@NotNull BigInteger numberOfBytes) {
        return new Byte(numberOfBytes);
    }

    @CheckReturnValue
    @NotNull
    public static Byte valueOf(long numberOfBytes) {
        return Byte.valueOf(BigInteger.valueOf(numberOfBytes));
    }

    @CheckReturnValue
    @NotNull
    public static Byte valueOf(@NotNull Long numberOfBytes) {
        return Byte.valueOf((long)numberOfBytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte add(long bytesToAdd) {
        return this.add(BigInteger.valueOf(bytesToAdd));
    }

    @Override
    @NotNull
    public Byte add(@NotNull BigInteger bytesToAdd) {
        return new Byte(this.bytes.add(bytesToAdd));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte add(@NotNull StorageUnit<?> storageAmount) {
        return this.add(storageAmount.bytes);
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte divide(long divisor) {
        return this.divide(BigInteger.valueOf(divisor));
    }

    @Override
    @NotNull
    public Byte divide(@NotNull BigInteger divisor) {
        return new Byte(this.bytes.divide(divisor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte multiply(long factor) {
        return new Byte(this.bytes.multiply(BigInteger.valueOf(factor)));
    }

    @Override
    @NotNull
    public Byte multiply(@NotNull BigInteger factor) {
        return new Byte(this.bytes.multiply(factor));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte subtract(long bytesToSubtract) {
        return new Byte(this.bytes.subtract(BigInteger.valueOf(bytesToSubtract)));
    }

    @Override
    @NotNull
    public Byte subtract(@NotNull BigInteger bytesToSubtract) {
        return new Byte(this.bytes.subtract(bytesToSubtract));
    }

    @Override
    @CheckReturnValue
    @NotNull
    public Byte subtract(@NotNull StorageUnit<?> storageAmount) {
        return new Byte(this.bytes.subtract(storageAmount.bytes));
    }

    @Override
    @NotNull
    protected BigInteger getNumberOfBytesPerUnit() {
        return BigInteger.ONE;
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected String getSymbol() {
        return "B";
    }

    @Override
    @CheckReturnValue
    @NotNull
    protected @NotNull Function<@NotNull BigInteger, @NotNull StorageUnit<?>> converter() {
        return StorageUnits::binaryValueOf;
    }
}

