/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class XEasyPdfTemplateImageUtil {
    public static BufferedImage rotate(BufferedImage sourceImage, Rectangle rectangle, double radians) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        if (radians % 360.0 == 0.0) {
            return sourceImage;
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        BufferedImage image = new BufferedImage(rectangle.width, rectangle.height, sourceImage.getType());
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics.translate((double)(rectangle.width - imageWidth) / 2.0, (double)(rectangle.height - imageHeight) / 2.0);
        graphics.rotate(Math.toRadians(radians), (double)imageWidth / 2.0, (double)imageHeight / 2.0);
        graphics.drawImage((Image)sourceImage, 0, 0, null);
        graphics.dispose();
        sourceImage.flush();
        return image;
    }
}

