/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.ext.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.BidiOverride;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ChangeBarBegin;
import org.apache.fop.fo.flow.ChangeBarEnd;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Float;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineContainer;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.MultiCase;
import org.apache.fop.fo.flow.MultiSwitch;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.flow.RetrieveTableMarker;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.ExternalDocumentLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.MultiCaseLayoutManager;
import org.apache.fop.layoutmgr.MultiSwitchLayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.RetrieveTableMarkerLayoutManager;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.BasicLinkLayoutManager;
import org.apache.fop.layoutmgr.inline.BidiLayoutManager;
import org.apache.fop.layoutmgr.inline.CharacterLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ExternalGraphicLayoutManager;
import org.apache.fop.layoutmgr.inline.FloatLayoutManager;
import org.apache.fop.layoutmgr.inline.FootnoteLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineContainerLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InstreamForeignObjectLM;
import org.apache.fop.layoutmgr.inline.LeaderLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLastLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberLayoutManager;
import org.apache.fop.layoutmgr.inline.WrapperLayoutManager;
import org.apache.fop.layoutmgr.list.ListBlockLayoutManager;
import org.apache.fop.layoutmgr.list.ListItemLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiki.xsx.core.pdf.template.ext.layout.XEasyPdfTemplateTextLayoutManager;

public class XEasyPdfTemplateLayoutManagerMapping
implements LayoutManagerMaker {
    private static final Logger log = LoggerFactory.getLogger(XEasyPdfTemplateLayoutManagerMapping.class);
    private final Map<Object, Object> makers = new HashMap<Object, Object>();
    private FOUserAgent userAgent;

    public void initialize(FOUserAgent userAgent) {
        this.userAgent = userAgent;
        this.registerMaker(FOText.class, new FOTextLayoutManagerMaker());
        this.registerMaker(FObjMixed.class, new Maker());
        this.registerMaker(BidiOverride.class, new BidiOverrideLayoutManagerMaker());
        this.registerMaker(Inline.class, new InlineLayoutManagerMaker());
        this.registerMaker(Footnote.class, new FootnoteLayoutManagerMaker());
        this.registerMaker(InlineContainer.class, new InlineContainerLayoutManagerMaker());
        this.registerMaker(BasicLink.class, new BasicLinkLayoutManagerMaker());
        this.registerMaker(Block.class, new BlockLayoutManagerMaker());
        this.registerMaker(Leader.class, new LeaderLayoutManagerMaker());
        this.registerMaker(RetrieveMarker.class, new RetrieveMarkerLayoutManagerMaker());
        this.registerMaker(RetrieveTableMarker.class, new RetrieveTableMarkerLayoutManagerMaker());
        this.registerMaker(Character.class, new CharacterLayoutManagerMaker());
        this.registerMaker(ExternalGraphic.class, new ExternalGraphicLayoutManagerMaker());
        this.registerMaker(BlockContainer.class, new BlockContainerLayoutManagerMaker());
        this.registerMaker(ListItem.class, new ListItemLayoutManagerMaker());
        this.registerMaker(ListBlock.class, new ListBlockLayoutManagerMaker());
        this.registerMaker(InstreamForeignObject.class, new InstreamForeignObjectLayoutManagerMaker());
        this.registerMaker(PageNumber.class, new PageNumberLayoutManagerMaker());
        this.registerMaker(PageNumberCitation.class, new PageNumberCitationLayoutManagerMaker());
        this.registerMaker(PageNumberCitationLast.class, new PageNumberCitationLastLayoutManagerMaker());
        this.registerMaker(Table.class, new TableLayoutManagerMaker());
        this.registerMaker(TableBody.class, new Maker());
        this.registerMaker(TableColumn.class, new Maker());
        this.registerMaker(TableRow.class, new Maker());
        this.registerMaker(TableCell.class, new Maker());
        this.registerMaker(TableFooter.class, new Maker());
        this.registerMaker(TableHeader.class, new Maker());
        this.registerMaker(Wrapper.class, new WrapperLayoutManagerMaker());
        this.registerMaker(Title.class, new InlineLayoutManagerMaker());
        this.registerMaker(ChangeBarBegin.class, new Maker());
        this.registerMaker(ChangeBarEnd.class, new Maker());
        this.registerMaker(MultiCase.class, new MultiCaseLayoutManagerMaker());
        this.registerMaker(MultiSwitch.class, new MultiSwitchLayoutManagerMaker());
        this.registerMaker(Float.class, new FloatLayoutManagerMaker());
    }

    protected void registerMaker(Class<?> clazz, Maker maker) {
        this.makers.put(clazz, maker);
    }

    public void makeLayoutManagers(FONode node, List lms) {
        Maker maker = (Maker)this.makers.get(node.getClass());
        if (maker == null) {
            if ("http://www.w3.org/1999/XSL/Format".equals(node.getNamespaceURI())) {
                log.error("No LayoutManager maker for class " + node.getClass());
            } else if (log.isDebugEnabled()) {
                log.debug("Skipping the creation of a layout manager for " + node.getClass());
            }
        } else {
            maker.make(node, lms, this.userAgent);
        }
    }

    public LayoutManager makeLayoutManager(FONode node) {
        ArrayList lms = new ArrayList();
        this.makeLayoutManagers(node, lms);
        if (lms.size() == 0) {
            throw new IllegalStateException("LayoutManager for class " + node.getClass() + " is missing.");
        }
        if (lms.size() > 1) {
            throw new IllegalStateException("Duplicate LayoutManagers for class " + node.getClass() + " found, only one may be declared.");
        }
        return (LayoutManager)lms.get(0);
    }

    public PageSequenceLayoutManager makePageSequenceLayoutManager(AreaTreeHandler ath, PageSequence ps) {
        return new PageSequenceLayoutManager(ath, ps);
    }

    public ExternalDocumentLayoutManager makeExternalDocumentLayoutManager(AreaTreeHandler ath, ExternalDocument ed) {
        return new ExternalDocumentLayoutManager(ath, ed);
    }

    public FlowLayoutManager makeFlowLayoutManager(PageSequenceLayoutManager pslm, Flow flow) {
        return new FlowLayoutManager(pslm, flow);
    }

    public ContentLayoutManager makeContentLayoutManager(PageSequenceLayoutManager pslm, Title title) {
        return new ContentLayoutManager(pslm, title);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent sc, SideRegion reg) {
        return new StaticContentLayoutManager(pslm, sc, reg);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent sc, org.apache.fop.area.Block block) {
        return new StaticContentLayoutManager(pslm, sc, block);
    }

    public static class FloatLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new FloatLayoutManager((Float)node));
        }
    }

    public static class MultiCaseLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new MultiCaseLayoutManager((FObj)((MultiCase)node)));
        }
    }

    public static class MultiSwitchLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new MultiSwitchLayoutManager((FObj)((MultiSwitch)node)));
        }
    }

    public class WrapperLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new WrapperLayoutManager((Wrapper)node));
            FONode.FONodeIterator baseIter = node.getChildNodes();
            if (baseIter == null) {
                return;
            }
            while (baseIter.hasNext()) {
                FONode child = (FONode)baseIter.next();
                XEasyPdfTemplateLayoutManagerMapping.this.makeLayoutManagers(child, lms);
            }
        }
    }

    public class RetrieveTableMarkerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            FONode.FONodeIterator baseIter = node.getChildNodes();
            if (baseIter == null) {
                lms.add(new RetrieveTableMarkerLayoutManager((RetrieveTableMarker)node));
                return;
            }
            while (baseIter.hasNext()) {
                FONode child = baseIter.next();
                XEasyPdfTemplateLayoutManagerMapping.this.makeLayoutManagers(child, lms);
            }
        }
    }

    public class RetrieveMarkerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            FONode.FONodeIterator baseIter = node.getChildNodes();
            if (baseIter == null) {
                return;
            }
            while (baseIter.hasNext()) {
                FONode child = (FONode)baseIter.next();
                XEasyPdfTemplateLayoutManagerMapping.this.makeLayoutManagers(child, lms);
            }
        }
    }

    public static class TableLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new TableLayoutManager((Table)node));
        }
    }

    public static class PageNumberCitationLastLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new PageNumberCitationLastLayoutManager((PageNumberCitationLast)node));
        }
    }

    public static class PageNumberCitationLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new PageNumberCitationLayoutManager((PageNumberCitation)node));
        }
    }

    public static class PageNumberLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new PageNumberLayoutManager((PageNumber)node));
        }
    }

    public static class InstreamForeignObjectLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new InstreamForeignObjectLM((InstreamForeignObject)node));
        }
    }

    public static class ListBlockLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new ListBlockLayoutManager((ListBlock)node));
        }
    }

    public static class ListItemLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new ListItemLayoutManager((ListItem)node));
        }
    }

    public static class BlockContainerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new BlockContainerLayoutManager((BlockContainer)node));
        }
    }

    public static class ExternalGraphicLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            ExternalGraphic eg = (ExternalGraphic)node;
            if (!eg.getSrc().equals("")) {
                lms.add(new ExternalGraphicLayoutManager(eg));
            }
        }
    }

    public static class CharacterLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            Character foCharacter = (Character)node;
            if (foCharacter.getCharacter() != '\u0000') {
                lms.add(new CharacterLayoutManager(foCharacter));
            }
        }
    }

    public static class LeaderLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new LeaderLayoutManager((Leader)node));
        }
    }

    public static class BlockLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new BlockLayoutManager((Block)node));
        }
    }

    public static class BasicLinkLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new BasicLinkLayoutManager((BasicLink)node));
        }
    }

    public static class InlineContainerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new InlineContainerLayoutManager((InlineContainer)node));
        }
    }

    public static class FootnoteLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new FootnoteLayoutManager((Footnote)node));
        }
    }

    public static class InlineLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            lms.add(new InlineLayoutManager((InlineLevel)node));
        }
    }

    public static class BidiOverrideLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            if (node instanceof BidiOverride) {
                lms.add(new BidiLayoutManager((BidiOverride)node));
            }
        }
    }

    public static class FOTextLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
            FOText foText = (FOText)node;
            if (foText.length() > 0) {
                lms.add((Object)new XEasyPdfTemplateTextLayoutManager(foText, userAgent));
            }
        }
    }

    public static class Maker {
        public void make(FONode node, List<Object> lms, FOUserAgent userAgent) {
        }
    }
}

