/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.page;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Objects;

public class XEasyPdfTemplatePageRectangle
implements Serializable {
    private static final long serialVersionUID = -8290831144835083352L;
    private static final Integer DEFAULT_DPI = 72;
    public static final Float POINTS_PER_MM = Float.valueOf(0.03937008f * (float)DEFAULT_DPI.intValue());
    private Integer dpi = DEFAULT_DPI;
    private Float width;
    private Float height;
    public static final XEasyPdfTemplatePageRectangle A0 = new XEasyPdfTemplatePageRectangle(841.0f * POINTS_PER_MM.floatValue(), 1189.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A1 = new XEasyPdfTemplatePageRectangle(594.0f * POINTS_PER_MM.floatValue(), 841.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A2 = new XEasyPdfTemplatePageRectangle(420.0f * POINTS_PER_MM.floatValue(), 594.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A3 = new XEasyPdfTemplatePageRectangle(297.0f * POINTS_PER_MM.floatValue(), 420.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A4 = new XEasyPdfTemplatePageRectangle(210.0f * POINTS_PER_MM.floatValue(), 297.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A5 = new XEasyPdfTemplatePageRectangle(148.0f * POINTS_PER_MM.floatValue(), 210.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A6 = new XEasyPdfTemplatePageRectangle(105.0f * POINTS_PER_MM.floatValue(), 148.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A7 = new XEasyPdfTemplatePageRectangle(74.0f * POINTS_PER_MM.floatValue(), 105.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle A8 = new XEasyPdfTemplatePageRectangle(52.0f * POINTS_PER_MM.floatValue(), 74.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B0 = new XEasyPdfTemplatePageRectangle(1030.0f * POINTS_PER_MM.floatValue(), 1456.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B1 = new XEasyPdfTemplatePageRectangle(728.0f * POINTS_PER_MM.floatValue(), 1030.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B2 = new XEasyPdfTemplatePageRectangle(515.0f * POINTS_PER_MM.floatValue(), 728.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B3 = new XEasyPdfTemplatePageRectangle(364.0f * POINTS_PER_MM.floatValue(), 515.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B4 = new XEasyPdfTemplatePageRectangle(257.0f * POINTS_PER_MM.floatValue(), 364.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B5 = new XEasyPdfTemplatePageRectangle(182.0f * POINTS_PER_MM.floatValue(), 257.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B6 = new XEasyPdfTemplatePageRectangle(128.0f * POINTS_PER_MM.floatValue(), 182.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B7 = new XEasyPdfTemplatePageRectangle(91.0f * POINTS_PER_MM.floatValue(), 128.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfTemplatePageRectangle B8 = new XEasyPdfTemplatePageRectangle(64.0f * POINTS_PER_MM.floatValue(), 91.0f * POINTS_PER_MM.floatValue());

    private XEasyPdfTemplatePageRectangle(float width, float height) {
        this.width = Float.valueOf(Math.abs(width));
        this.height = Float.valueOf(Math.abs(height));
    }

    public static XEasyPdfTemplatePageRectangle create(float width, float height) {
        return new XEasyPdfTemplatePageRectangle(width, height);
    }

    public static Rectangle getRotateRectangle(int width, int height, double radians) {
        Rectangle src = new Rectangle(new Dimension(width, height));
        int angle = 90;
        int num = 2;
        if (radians < 0.0) {
            radians += 360.0;
        }
        if (radians % 360.0 == 0.0) {
            return src;
        }
        if (radians >= 90.0) {
            if (radians / 90.0 % 2.0 == 1.0) {
                return new Rectangle((int)src.getHeight(), (int)src.getWidth());
            }
            radians %= 90.0;
        }
        double radius = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(radians) / 2.0) * radius;
        double radiansAlpha = (Math.PI - Math.toRadians(radians)) / 2.0;
        double radiansWidth = Math.atan((double)src.height / (double)src.width);
        double radiansHeight = Math.atan((double)src.width / (double)src.height);
        int lenWidth = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansWidth)));
        int lenHeight = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansHeight)));
        return new Rectangle(src.width + lenWidth * 2, src.height + lenHeight * 2);
    }

    public XEasyPdfTemplatePageRectangle setDpi(int dpi) {
        this.dpi = Math.abs(dpi);
        this.width = Float.valueOf(this.width.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue());
        this.height = Float.valueOf(this.height.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue());
        return this;
    }

    public XEasyPdfTemplatePageRectangle changeLandscape() {
        return new XEasyPdfTemplatePageRectangle(this.height.floatValue(), this.width.floatValue());
    }

    public float getUnit() {
        if (Objects.equals(this.dpi, DEFAULT_DPI)) {
            return POINTS_PER_MM.floatValue();
        }
        return POINTS_PER_MM.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue();
    }

    public float getWidth() {
        return this.width.floatValue();
    }

    public float getHeight() {
        return this.height.floatValue();
    }
}

