/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.datasource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import wiki.xsx.core.pdf.template.datasource.XEasyPdfTemplateAbstractDataSource;
import wiki.xsx.core.pdf.template.doc.XEasyPdfTemplateDocumentComponent;

public class XEasyPdfTemplateDocumentDataSource
extends XEasyPdfTemplateAbstractDataSource {
    private XEasyPdfTemplateDocumentComponent document;

    public XEasyPdfTemplateDocumentDataSource() {
        this.templateData = Collections.singletonMap("", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected InputStream processTemplate() {
        if (this.document == null) {
            throw new IllegalArgumentException("the document can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.document.getDocument()), new StreamResult(outputStream));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
            return bufferedInputStream;
        }
    }

    public XEasyPdfTemplateDocumentDataSource setDocument(XEasyPdfTemplateDocumentComponent document) {
        this.document = document;
        return this;
    }
}

