/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.timer;

import java.util.concurrent.DelayQueue;
import vip.justlive.oxygen.core.util.timer.Slot;
import vip.justlive.oxygen.core.util.timer.Task;

public class Wheel {
    private final long duration;
    private final long interval;
    private final Slot[] slots;
    private final DelayQueue<Slot> delayQueue;
    private long currentTime;
    private Wheel overflowWheel;

    public Wheel(long duration, int wheelSize, long startTime, DelayQueue<Slot> delayQueue) {
        this.duration = duration;
        this.interval = duration * (long)wheelSize;
        this.slots = Slot.createSlots(wheelSize);
        this.currentTime = startTime - startTime % duration;
        this.delayQueue = delayQueue;
    }

    boolean add(Task<?> task) {
        if (task.isCancelled()) {
            return false;
        }
        if (task.deadline < this.currentTime + this.duration) {
            return false;
        }
        if (task.deadline < this.currentTime + this.interval) {
            long virtualId = task.deadline / this.duration;
            Slot slot = this.slots[(int)(virtualId % (long)this.slots.length)];
            slot.addTask(task);
            if (slot.setDeadline(virtualId * this.duration)) {
                this.delayQueue.offer(slot);
            }
            return true;
        }
        if (this.overflowWheel == null) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(task);
    }

    void advanceClock(long currentTime) {
        if (currentTime >= this.currentTime + this.duration) {
            this.currentTime = currentTime - currentTime % this.duration;
        }
        if (this.overflowWheel != null) {
            this.overflowWheel.advanceClock(this.currentTime);
        }
    }

    private synchronized void addOverflowWheel() {
        this.overflowWheel = new Wheel(this.interval, this.slots.length, this.currentTime, this.delayQueue);
    }
}

