/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.timer;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.util.timer.Slot;

public class Task<T>
extends FutureTask<T>
implements ScheduledFuture<T> {
    long deadline;
    Task<?> next;
    Task<?> prev;
    Slot slot;

    Task(long deadline, Callable<T> callable) {
        super(callable);
        this.deadline = deadline;
    }

    Task(long deadline, Runnable runnable) {
        super(runnable, null);
        this.deadline = deadline;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.slot != null) {
            this.slot.remove(this);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.compare(this.deadline, ((Task)o).deadline);
    }
}

