/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.retry;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.ThreadUtils;
import vip.justlive.oxygen.core.util.retry.AsyncRetryer;
import vip.justlive.oxygen.core.util.retry.Attempt;
import vip.justlive.oxygen.core.util.retry.Retryer;
import vip.justlive.oxygen.core.util.retry.TimeLimiter;

public class RetryBuilder<T> {
    private final List<Consumer<Attempt<T>>> retryListeners = new LinkedList<Consumer<Attempt<T>>>();
    private final List<Consumer<Attempt<T>>> failListeners = new LinkedList<Consumer<Attempt<T>>>();
    private final List<Consumer<Attempt<T>>> successListeners = new LinkedList<Consumer<Attempt<T>>>();
    private Predicate<Attempt<T>> retryPredicate = attempt -> false;
    private Predicate<Attempt<T>> stopPredicate = attempt -> false;
    private Consumer<Attempt<T>> blockConsumer = attempt -> {};
    private long waitTime = 0L;
    private TimeLimiter<T> timeLimiter;
    private ScheduledExecutorService scheduledExecutorService;

    private RetryBuilder() {
    }

    public static <T> RetryBuilder<T> newBuilder() {
        return new RetryBuilder<T>();
    }

    public RetryBuilder<T> retryIfException() {
        return this.retryIf(Attempt::hasException);
    }

    public RetryBuilder<T> retryIfException(Class<? extends Exception> exceptionClass) {
        return this.retryIf(attempt -> attempt.hasException() && exceptionClass.isAssignableFrom(attempt.getException().getClass()));
    }

    public RetryBuilder<T> retryIfResult(Predicate<T> resultPredicate) {
        return this.retryIf(attempt -> !attempt.hasException() && resultPredicate.test(attempt.getResult()));
    }

    public RetryBuilder<T> retryIf(Predicate<Attempt<T>> predicate) {
        this.retryPredicate = this.retryPredicate.or(predicate);
        return this;
    }

    public RetryBuilder<T> withTimeLimit(long timeout, TimeUnit timeUnit) {
        return this.withTimeLimit(timeout, timeUnit, ThreadUtils.globalPool());
    }

    public RetryBuilder<T> withTimeLimit(long timeout, TimeUnit timeUnit, ExecutorService executorService) {
        this.timeLimiter = TimeLimiter.fixedTimeLimit(timeout, timeUnit, executorService);
        return this;
    }

    public RetryBuilder<T> withMaxAttempt(long maxAttempt) {
        this.stopPredicate = this.stopPredicate.or(attempt -> attempt.getAttemptNumber() >= maxAttempt);
        return this;
    }

    public RetryBuilder<T> withMaxDelay(long maxDelay) {
        this.stopPredicate = this.stopPredicate.or(attempt -> attempt.getMillsAfterFirstAttempt() >= maxDelay);
        return this;
    }

    public RetryBuilder<T> withNeverStop() {
        this.stopPredicate = attempt -> false;
        return this;
    }

    public RetryBuilder<T> withSleepBlock(long waitTime) {
        if (waitTime < 0L) {
            throw new IllegalArgumentException(String.format("waitTime [%s] mast be >= 0", waitTime));
        }
        this.waitTime = waitTime;
        this.blockConsumer = attempt -> ThreadUtils.sleep(waitTime);
        return this;
    }

    public RetryBuilder<T> withWaitBlock(long waitTime) {
        if (waitTime < 0L) {
            throw new IllegalArgumentException(String.format("waitTime [%s] mast be >= 0", waitTime));
        }
        this.waitTime = waitTime;
        this.blockConsumer = attempt -> this.waitBlock(waitTime);
        return this;
    }

    public RetryBuilder<T> withBlock(Consumer<Attempt<T>> consumer) {
        this.blockConsumer = consumer;
        return this;
    }

    public RetryBuilder<T> onRetry(Consumer<Attempt<T>> listener) {
        this.retryListeners.add(MoreObjects.notNull(listener));
        return this;
    }

    public RetryBuilder<T> onFinalFail(Consumer<Attempt<T>> listener) {
        this.failListeners.add(MoreObjects.notNull(listener));
        return this;
    }

    public RetryBuilder<T> onSuccess(Consumer<Attempt<T>> listener) {
        this.successListeners.add(MoreObjects.notNull(listener));
        return this;
    }

    public RetryBuilder<T> withAsyncExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = MoreObjects.notNull(scheduledExecutorService);
        return this;
    }

    public Retryer<T> build() {
        if (this.timeLimiter == null) {
            this.timeLimiter = TimeLimiter.noTimeLimit();
        }
        Retryer retryer = new Retryer();
        this.configure(retryer);
        return retryer;
    }

    public AsyncRetryer<T> buildAsync() {
        if (this.timeLimiter == null) {
            this.timeLimiter = TimeLimiter.noTimeLimit();
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = ThreadUtils.newScheduledExecutor(5, "retry-async-%d");
        }
        AsyncRetryer retryer = new AsyncRetryer();
        this.configure(retryer);
        retryer.scheduledExecutorService = this.scheduledExecutorService;
        retryer.waitTime = this.waitTime;
        return retryer;
    }

    private void configure(Retryer<T> retryer) {
        retryer.timeLimiter = this.timeLimiter;
        retryer.retryPredicate = this.retryPredicate;
        retryer.stopPredicate = this.stopPredicate;
        retryer.blockConsumer = this.blockConsumer;
        retryer.retryListeners = this.retryListeners;
        retryer.failListeners = this.failListeners;
        retryer.successListeners = this.successListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitBlock(long millis) {
        long last = System.currentTimeMillis() + millis;
        long remains = millis;
        RetryBuilder retryBuilder = this;
        synchronized (retryBuilder) {
            try {
                while (remains > 0L) {
                    this.wait(remains);
                    remains = last - System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

