/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.retry;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.retry.TimeLimiter;

public class FixedTimeLimiter<V>
implements TimeLimiter<V> {
    private final long timeout;
    private final TimeUnit timeUnit;
    private final ExecutorService executorService;

    public FixedTimeLimiter(long timeout, TimeUnit timeUnit, ExecutorService executorService) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException(String.format("timeout must be positive:%s", timeout));
        }
        this.timeout = timeout;
        this.timeUnit = MoreObjects.notNull(timeUnit);
        this.executorService = MoreObjects.notNull(executorService);
    }

    @Override
    public V call(Callable<V> callable) {
        Future<V> future = this.executorService.submit(callable);
        try {
            return future.get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            future.cancel(true);
            throw Exceptions.wrap(e);
        }
    }
}

