/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.util.List;
import java.util.Map;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class MapSerializer
implements Serializer {
    private final List<Serializer> serializers;

    @Override
    public boolean supported(Class<?> type, Object value) {
        return value != null && Map.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        buf.append('{');
        boolean del = false;
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Serializer serializer = Serializer.lookup(this.serializers, entry.getValue());
            if (serializer == null) continue;
            buf.append('\"').append(this.getKey(entry)).append("\":");
            serializer.serialize(entry.getValue(), buf);
            buf.append(',');
            del = true;
        }
        if (del) {
            buf.deleteCharAt(buf.length() - 1).append('}');
        }
    }

    private String getKey(Map.Entry<?, ?> entry) {
        Object key = entry.getKey();
        if (key == null) {
            return "null";
        }
        return key.toString();
    }

    public MapSerializer(List<Serializer> serializers) {
        this.serializers = serializers;
    }
}

