/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class BeanSerializer
implements Serializer {
    private final List<Serializer> serializers;

    @Override
    public int order() {
        return 50;
    }

    @Override
    public boolean supported(Class<?> type, Object value) {
        return value != null && !ClassUtils.isJavaInternalType(type);
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        Class<?> type = value.getClass();
        try {
            PropertyDescriptor[] props = Introspector.getBeanInfo(type).getPropertyDescriptors();
            buf.append('{');
            for (PropertyDescriptor prop : props) {
                if (!this.processProperty(value, prop, buf)) continue;
                buf.append(',');
            }
            buf.deleteCharAt(buf.length() - 1).append('}');
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.wrap(e);
        }
    }

    private boolean processProperty(Object bean, PropertyDescriptor prop, StringBuilder buf) throws InvocationTargetException, IllegalAccessException {
        Method method = prop.getReadMethod();
        if (method == null || method.getParameterCount() > 0) {
            return false;
        }
        Object value = method.invoke(bean, new Object[0]);
        Serializer serializer = Serializer.lookup(this.serializers, value);
        if (serializer == null) {
            return false;
        }
        buf.append('\"').append(prop.getName()).append("\":");
        serializer.serialize(value, buf);
        return true;
    }

    public BeanSerializer(List<Serializer> serializers) {
        this.serializers = serializers;
    }
}

