/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.lang.reflect.Array;
import java.util.List;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class ArraySerializer
implements Serializer {
    private final List<Serializer> serializers;

    @Override
    public int order() {
        return 50;
    }

    @Override
    public boolean supported(Class<?> type, Object value) {
        return value != null && type.isArray();
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        buf.append('[');
        int length = Array.getLength(value);
        boolean del = false;
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(value, i);
            Serializer serializer = Serializer.lookup(this.serializers, item);
            if (serializer == null) continue;
            serializer.serialize(item, buf);
            buf.append(',');
            del = true;
        }
        if (del) {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append(']');
    }

    public ArraySerializer(List<Serializer> serializers) {
        this.serializers = serializers;
    }
}

