/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ServerSocketFactory;
import vip.justlive.oxygen.core.exception.Exceptions;

public final class SystemUtils {
    public static final int DEFAULT_PORT_RANGE_MIN = 10000;
    public static final int PORT_RANGE_MAX = 65535;

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean isAvailablePort(int port) {
        if (!SystemUtils.isValidPort(port)) {
            return false;
        }
        try {
            ServerSocket socket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getLocalHost());
            socket.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int findAvailablePort() {
        return SystemUtils.findAvailablePort(10000);
    }

    public static int findAvailablePort(int minPort) {
        return SystemUtils.findAvailablePort(minPort, 65535);
    }

    public static int findAvailablePort(int minPort, int maxPort) {
        int searchCounter;
        if (minPort < 0) {
            throw Exceptions.fail("'minPort' must be greater than 0");
        }
        if (minPort > maxPort) {
            throw Exceptions.fail("'maxPort' must be greater than or equal to 'minPort'");
        }
        if (maxPort > 65535) {
            throw Exceptions.fail("'maxPort' must be less than or equal to 65535");
        }
        int portRange = maxPort - minPort;
        for (searchCounter = 0; searchCounter < portRange; ++searchCounter) {
            int port = ThreadLocalRandom.current().nextInt(portRange + 1);
            if (!SystemUtils.isAvailablePort(port)) continue;
            return port;
        }
        throw Exceptions.fail(String.format("Can not find available port in range [%d, %d] after [%d] attempts", minPort, maxPort, searchCounter));
    }

    public static InetSocketAddress parseAddress(String address) {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        String[] hostPort = address.trim().split(":");
        return new InetSocketAddress(hostPort[0].trim(), Integer.parseInt(hostPort[1].trim()));
    }

    public static InetAddress getLocalAddress() {
        InetAddress candidateAddress = null;
        try {
            candidateAddress = SystemUtils.getByNetworkInterfaces(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (candidateAddress == null) {
            try {
                candidateAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return candidateAddress;
    }

    public static int pid() {
        try {
            String name = (String)Class.forName("java.lang.management.RuntimeMXBean").getDeclaredMethod("getName", new Class[0]).invoke(Class.forName("java.lang.management.ManagementFactory").getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]), new Object[0]);
            return Integer.parseInt(name.split("@")[0]);
        }
        catch (Exception ex) {
            try {
                File proc = new File("/proc/self").getCanonicalFile();
                if (proc.exists()) {
                    return Integer.parseInt(proc.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    private static InetAddress getByNetworkInterfaces(Enumeration<NetworkInterface> interfaces) {
        InetAddress candidateAddress = null;
        while (interfaces.hasMoreElements()) {
            NetworkInterface network = interfaces.nextElement();
            Enumeration<InetAddress> addresses = network.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isSiteLocalAddress()) {
                    return address;
                }
                if (address.isLoopbackAddress() && address.isLinkLocalAddress()) continue;
                candidateAddress = address;
            }
        }
        return candidateAddress;
    }

    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

