/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import vip.justlive.oxygen.core.util.Strings;

public final class SensitiveUtils {
    private static final int BANK_CARD_LENGTH = 16;
    private static final int PHONE_LENGTH = 11;

    public static String nameHide(String data) {
        return SensitiveUtils.customizeHide(data, 1, 0, 2);
    }

    public static String idCardNoHide(String data) {
        if (!Strings.hasText(data)) {
            return data;
        }
        return SensitiveUtils.customizeHide(data, 2, 2, data.length() - 4);
    }

    public static String bankCardNoHide(String data) {
        if (!Strings.hasText(data)) {
            return data;
        }
        if (data.length() >= 16) {
            return SensitiveUtils.customizeHide(data, 6, 4, data.length() - 10);
        }
        return SensitiveUtils.defaultHide(data);
    }

    public static String cellphoneHide(String data) {
        if (!Strings.hasText(data)) {
            return data;
        }
        String tmp = data.trim();
        if (tmp.length() == 11) {
            return SensitiveUtils.customizeHide(tmp, 3, 2, 6);
        }
        int notHideNum = tmp.length() - 4;
        return SensitiveUtils.customizeHide(tmp, notHideNum / 2, notHideNum - notHideNum / 2, 4);
    }

    public static String emailHide(String data) {
        if (!Strings.hasText(data)) {
            return data;
        }
        String tmp = data.trim();
        int atPos = tmp.indexOf("@");
        if (atPos == -1) {
            return SensitiveUtils.defaultHide(data);
        }
        int frontNum = Math.min(atPos, 3);
        return SensitiveUtils.customizeHide(tmp, frontNum, tmp.length() - atPos, 3);
    }

    public static String defaultHide(String data) {
        if (!Strings.hasText(data)) {
            return data;
        }
        String tmp = data.trim();
        int length = tmp.length();
        int headNum = (int)Math.ceil((double)length / 3.0);
        int tailNum = (int)Math.floor((double)length / 3.0);
        return SensitiveUtils.customizeHide(tmp, headNum, tailNum, length - headNum - tailNum);
    }

    public static String customizeHide(String data, int front, int tail, int hidden) {
        if (!Strings.hasText(data)) {
            return data;
        }
        String tmp = data.trim();
        int length = tmp.length();
        if (front < 0 || tail < 0 || hidden < 0 || front + tail > length) {
            return tmp;
        }
        int beginIndex = front - 1;
        int endIndex = length - tail;
        StringBuilder result = new StringBuilder();
        if (beginIndex >= 0 && beginIndex < length) {
            result.append(tmp, 0, front);
        }
        for (int i = 0; i < hidden; ++i) {
            result.append("*");
        }
        if (endIndex >= 0 && endIndex < length) {
            result.append(tmp.substring(endIndex));
        }
        return result.toString();
    }

    private SensitiveUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

