/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class NumberUtils {
    public static final String OCTONARY_PREFIX = "0";
    public static final String HEX_PREFIX_0 = "0x";
    public static final String HEX_PREFIX_1 = "0X";
    public static final List<Class<? extends Number>> STANDARD_NUMBER_TYPES = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, BigInteger.class, Float.class, Double.class, BigDecimal.class);
    private static final Map<Class<?>, Function<String, ?>> FUNCTIONS = new HashMap(16, 1.0f);

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        MoreObjects.notNull(text, "Text must not be null");
        MoreObjects.notNull(targetClass, "Target class must not be null");
        String trimmed = text.trim();
        Function<String, ?> func = FUNCTIONS.get(targetClass);
        if (func == null) {
            throw new IllegalArgumentException(String.format("Cannot convert String [%s] to target class [%s]", text, targetClass.getName()));
        }
        return (T)((Number)func.apply(trimmed));
    }

    public static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith(HEX_PREFIX_0, index) || value.startsWith(HEX_PREFIX_1, index) || value.startsWith("#", index);
    }

    public static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith(HEX_PREFIX_0, index) || value.startsWith(HEX_PREFIX_1, index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith(OCTONARY_PREFIX, index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static BigDecimal stringToBigDecimal(String val) {
        return new BigDecimal(val);
    }

    private NumberUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        FUNCTIONS.put(Byte.class, trimmed -> NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        FUNCTIONS.put(Short.class, trimmed -> NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        FUNCTIONS.put(Integer.class, trimmed -> NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        FUNCTIONS.put(Long.class, trimmed -> NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        FUNCTIONS.put(BigInteger.class, trimmed -> NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger((String)trimmed));
        FUNCTIONS.put(Float.class, Float::valueOf);
        FUNCTIONS.put(Double.class, Double::valueOf);
        FUNCTIONS.put(BigDecimal.class, NumberUtils::stringToBigDecimal);
        FUNCTIONS.put(Number.class, NumberUtils::stringToBigDecimal);
    }
}

