/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import vip.justlive.oxygen.core.util.Bytes;

public final class IoUtils {
    private static final int BUFFER_SIZE = 4096;

    public static long drain(InputStream input) throws IOException {
        int bytesRead;
        long byteCount = 0L;
        if (input == null) {
            return byteCount;
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = input.read(buffer)) != -1) {
            byteCount += (long)bytesRead;
        }
        return byteCount;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IoUtils.copy(input, (byte[] buffer, int bytesRead) -> output.write(buffer, 0, bytesRead));
    }

    public static long copy(InputStream input, Bytes bytes) throws IOException {
        return IoUtils.copy(input, (byte[] buffer, int bytesRead) -> bytes.write(buffer, 0, bytesRead));
    }

    public static long copy(InputStream input, CopyOperate operate) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while ((bytesRead = input.read(buffer)) != -1) {
            operate.copy(buffer, bytesRead);
            count += (long)bytesRead;
        }
        return count;
    }

    public static byte[] toBytes(InputStream input) throws IOException {
        Bytes bytes = new Bytes();
        IoUtils.copy(input, bytes);
        return bytes.toArray();
    }

    public static String toString(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IoUtils.copy(input, output);
        return output.toString();
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IoUtils.copy(input, output);
        return output.toString(charset.name());
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private IoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface CopyOperate {
        public void copy(byte[] var1, int var2) throws IOException;
    }
}

