/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import vip.justlive.oxygen.core.util.FileUtils;

public class FileCleaner
implements AutoCloseable {
    private final Deque<File> deque = new ArrayDeque<File>(4);

    public void track(File file) {
        if (file != null) {
            this.deque.add(file);
        }
    }

    public void track(Path path) {
        if (path != null) {
            this.deque.add(path.toFile());
        }
    }

    @Override
    public void close() {
        while (!this.deque.isEmpty()) {
            FileUtils.delete(this.deque.pop());
        }
    }
}

