/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class ExecutorPool<V>
extends ExecutorCompletionService<V> {
    private static final Logger log = LoggerFactory.getLogger(ExecutorPool.class);
    private final AtomicInteger count = new AtomicInteger(0);

    public ExecutorPool() {
        this(ThreadUtils.globalPool());
    }

    public ExecutorPool(Executor executor) {
        super(executor);
    }

    public ExecutorPool(Executor executor, BlockingQueue<Future<V>> completionQueue) {
        super(executor, completionQueue);
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        Future<V> future = super.submit(task);
        this.count.incrementAndGet();
        return future;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        Future<V> future = super.submit(task, result);
        this.count.incrementAndGet();
        return future;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        Future future = super.take();
        this.count.decrementAndGet();
        return future;
    }

    @Override
    public Future<V> poll() {
        Future future = super.poll();
        if (future != null) {
            this.count.decrementAndGet();
        }
        return future;
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future future = super.poll(timeout, unit);
        if (future != null) {
            this.count.decrementAndGet();
        }
        return future;
    }

    public Future<V> submit(Runnable task) {
        return this.submit(task, null);
    }

    public List<V> waitFor() throws InterruptedException, ExecutionException {
        LinkedList<V> list = new LinkedList<V>();
        while (this.count.get() > 0) {
            list.add(this.take().get());
        }
        return list;
    }

    public List<V> waitForAll() {
        LinkedList<V> list = new LinkedList<V>();
        while (this.count.get() > 0) {
            try {
                list.add(this.take().get());
            }
            catch (Exception e) {
                log.error("wait for result error", (Throwable)e);
            }
        }
        return list;
    }
}

