/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;

public class CronExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> MONTH_MAP = new HashMap<String, String>(12, 1.0f);
    private static final Map<String, String> WEEK_MAP = new HashMap<String, String>(7, 1.0f);
    private static final String MONTH_VALUES = "JAN,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC,FOO";
    private static final String WEEK_VALUES = "SUN,MON,TUE,WED,THU,FRI,SAT";
    private static final int MAX_DEEP = 4;
    private static final int CRON_FIELDS = 6;
    private final String expression;
    private final TimeZone timeZone;
    private final BitSet months = new BitSet(12);
    private final BitSet daysOfMonth = new BitSet(31);
    private final BitSet daysOfWeek = new BitSet(7);
    private final BitSet hours = new BitSet(24);
    private final BitSet minutes = new BitSet(60);
    private final BitSet seconds = new BitSet(60);

    public CronExpression(String expression) {
        this(expression, TimeZone.getDefault());
    }

    public CronExpression(String expression, TimeZone timeZone) {
        this.expression = expression;
        this.timeZone = timeZone;
        this.parse();
    }

    public Date next(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).setTimeZone(this.timeZone);
        calendar.setTime(date);
        calendar.set(14, 0);
        long originalTimestamp = calendar.getTimeInMillis();
        this.doNext(calendar, calendar.get(1));
        if (calendar.getTimeInMillis() == originalTimestamp) {
            ((Calendar)calendar).add(13, 1);
            this.doNext(calendar, calendar.get(1));
        }
        return calendar.getTime();
    }

    public LongUnaryOperator operator() {
        return new CronOperator(this);
    }

    public String toString() {
        return "cron(" + this.expression + ")";
    }

    private void doNext(Calendar calendar, int dot) {
        int updateMinute;
        int minute;
        List<Integer> emptyList;
        int updateSecond;
        ArrayList<Integer> resets = new ArrayList<Integer>();
        int second = calendar.get(13);
        if (second == (updateSecond = this.findNext(this.seconds, second, calendar, 13, 12, emptyList = Collections.emptyList()))) {
            resets.add(13);
        }
        if ((minute = calendar.get(12)) == (updateMinute = this.findNext(this.minutes, minute, calendar, 12, 11, resets))) {
            resets.add(12);
        } else {
            this.doNext(calendar, dot);
        }
        int hour = calendar.get(11);
        int updateHour = this.findNext(this.hours, hour, calendar, 11, 7, resets);
        if (hour == updateHour) {
            resets.add(11);
        } else {
            this.doNext(calendar, dot);
        }
        int dayOfWeek = calendar.get(7);
        int dayOfMonth = calendar.get(5);
        int updateDayOfMonth = this.findNextDay(calendar, this.daysOfMonth, dayOfMonth, this.daysOfWeek, dayOfWeek, resets);
        if (dayOfMonth == updateDayOfMonth) {
            resets.add(5);
        } else {
            this.doNext(calendar, dot);
        }
        int month = calendar.get(2);
        int updateMonth = this.findNext(this.months, month, calendar, 2, 1, resets);
        if (month != updateMonth) {
            if (calendar.get(1) - dot > 4) {
                throw new IllegalArgumentException("Invalid cron expression \"" + this.expression + "\" led to runaway search for next trigger");
            }
            this.doNext(calendar, dot);
        }
    }

    private int findNextDay(Calendar calendar, BitSet daysOfMonth, int dayOfMonth, BitSet daysOfWeek, int dayOfWeek, List<Integer> resets) {
        int count = 0;
        int max = 366;
        while (!(daysOfMonth.get(dayOfMonth) && daysOfWeek.get(dayOfWeek - 1) || count++ >= max)) {
            calendar.add(5, 1);
            dayOfMonth = calendar.get(5);
            dayOfWeek = calendar.get(7);
            this.reset(calendar, resets);
        }
        if (count >= max) {
            throw new IllegalArgumentException("Overflow in day for expression \"" + this.expression + "\"");
        }
        return dayOfMonth;
    }

    private int findNext(BitSet bits, int value, Calendar calendar, int field, int nextField, List<Integer> lowerOrders) {
        int nextValue = bits.nextSetBit(value);
        if (nextValue == -1) {
            calendar.add(nextField, 1);
            this.reset(calendar, Collections.singletonList(field));
            nextValue = bits.nextSetBit(0);
        }
        if (nextValue != value) {
            calendar.set(field, nextValue);
            this.reset(calendar, lowerOrders);
        }
        return nextValue;
    }

    private void reset(Calendar calendar, List<Integer> fields) {
        Iterator<Integer> iterator = fields.iterator();
        while (iterator.hasNext()) {
            int field;
            calendar.set(field, (field = iterator.next().intValue()) == 5 ? 1 : 0);
        }
    }

    private void parse() {
        String[] fields = this.expression.split("\\s+");
        if (fields.length != 6) {
            throw Exceptions.fail("expression should have 6 fields");
        }
        this.setNumberBit(this.seconds, fields[0], 60);
        this.setNumberBit(this.minutes, fields[1], 60);
        this.setNumberBit(this.hours, fields[2], 24);
        this.setDaysOfMonth(fields[3]);
        this.setMonths(fields[4]);
        this.setDaysOfWeek(fields[5]);
    }

    private void setDaysOfWeek(String field) {
        for (Map.Entry<String, String> entry : WEEK_MAP.entrySet()) {
            field = field.replace(entry.getKey(), entry.getValue());
        }
        this.setNumberBit(this.daysOfWeek, field, 7);
    }

    private void setMonths(String field) {
        for (Map.Entry<String, String> entry : MONTH_MAP.entrySet()) {
            field = field.replace(entry.getKey(), entry.getValue());
        }
        this.setNumberBit(this.months, field, 13);
        for (int i = 1; i <= MONTH_MAP.size(); ++i) {
            this.months.set(i - 1, this.months.get(i));
        }
    }

    private void setDaysOfMonth(String field) {
        this.setNumberBit(this.daysOfMonth, field, 32);
        this.daysOfMonth.clear(0);
    }

    private void setNumberBit(BitSet bit, String field, int size) {
        for (String line : field.split(",")) {
            if ("*".equals(line.trim()) || "?".equals(line.trim())) {
                bit.set(0, size);
                continue;
            }
            if (line.contains("/")) {
                this.parseDuration(bit, line, size);
                continue;
            }
            if (line.contains("-")) {
                String[] fromTo = line.split("-");
                if (fromTo.length != 2) {
                    throw Exceptions.fail(this.errorMessage());
                }
                bit.set(Integer.parseInt(fromTo[0].trim()), Integer.parseInt(fromTo[1].trim()) + 1);
                continue;
            }
            bit.set(Integer.parseInt(line.trim()));
        }
    }

    private void parseDuration(BitSet bit, String line, int size) {
        int from;
        String[] arr = line.split("/");
        if (arr.length != 2) {
            throw Exceptions.fail(this.errorMessage());
        }
        int step = Integer.parseInt(arr[1].trim());
        if (step < 1) {
            throw Exceptions.fail(this.errorMessage());
        }
        int to = size - 1;
        if (arr[0].contains("-")) {
            String[] fromTo = arr[0].split("-");
            if (fromTo.length != 2) {
                throw Exceptions.fail(this.errorMessage());
            }
            from = Integer.parseInt(fromTo[0].trim());
            to = Integer.parseInt(fromTo[1].trim());
        } else {
            from = Integer.parseInt(arr[0].trim());
        }
        for (int i = from; i <= to; i += step) {
            bit.set(i);
        }
    }

    private String errorMessage() {
        return String.format("illegal expression '%s'", this.expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    static {
        int i = 1;
        for (String month : MONTH_VALUES.split(",")) {
            MONTH_MAP.put(month, String.valueOf(i++));
        }
        i = 0;
        for (String week : WEEK_VALUES.split(",")) {
            WEEK_MAP.put(week, String.valueOf(i++));
        }
    }

    private static class CronOperator
    implements LongUnaryOperator {
        private static final Logger log = LoggerFactory.getLogger(CronOperator.class);
        private final CronExpression expression;

        @Override
        public long applyAsLong(long operand) {
            Date now = new Date();
            Date nextDate = this.expression.next(now);
            if (nextDate == null) {
                log.warn("The {} doesn't have any match in the future.", (Object)this.expression);
                return Long.MIN_VALUE;
            }
            return nextDate.getTime();
        }

        public CronOperator(CronExpression expression) {
            this.expression = expression;
        }
    }
}

