/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;

public class CaughtConsumer<T>
implements Consumer<T> {
    private static final Logger log = LoggerFactory.getLogger(CaughtConsumer.class);
    private final Consumer<T> consumer;
    private final boolean thrown;

    public CaughtConsumer(Consumer<T> consumer) {
        this(consumer, false);
    }

    @Override
    public void accept(T t) {
        try {
            this.consumer.accept(t);
        }
        catch (Exception e) {
            if (this.thrown) {
                throw Exceptions.wrap(e);
            }
            log.error("consumer error", (Throwable)e);
        }
    }

    @Override
    public CaughtConsumer<T> andThen(Consumer<? super T> after) {
        return new CaughtConsumer<T>(Consumer.super.andThen(after), this.thrown);
    }

    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    public boolean isThrown() {
        return this.thrown;
    }

    public CaughtConsumer(Consumer<T> consumer, boolean thrown) {
        this.consumer = consumer;
        this.thrown = thrown;
    }
}

