/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;

public class CaughtCallable<V>
implements Callable<V> {
    private static final Logger log = LoggerFactory.getLogger(CaughtCallable.class);
    private final Callable<V> callable;
    private final boolean thrown;
    private final V failedValue;

    public CaughtCallable(Callable<V> callable) {
        this(callable, true, null);
    }

    public CaughtCallable(Callable<V> callable, V failedValue) {
        this(callable, false, failedValue);
    }

    @Override
    public V call() {
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            if (this.thrown) {
                throw Exceptions.wrap(e);
            }
            log.error("callable error", (Throwable)e);
            return this.failedValue;
        }
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public boolean isThrown() {
        return this.thrown;
    }

    public V getFailedValue() {
        return this.failedValue;
    }

    public CaughtCallable(Callable<V> callable, boolean thrown, V failedValue) {
        this.callable = callable;
        this.thrown = thrown;
        this.failedValue = failedValue;
    }
}

