/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractQueueWorker<T>
implements Runnable {
    private static final int MAX_LOOP = 10;
    protected final LinkedBlockingQueue<T> queue = new LinkedBlockingQueue();
    protected final Executor executor;
    protected volatile boolean stopped;
    private volatile boolean running;

    protected AbstractQueueWorker(Executor executor) {
        this.executor = executor;
    }

    public boolean add(T data) {
        if (this.stopped) {
            return false;
        }
        return this.queue.offer(data);
    }

    public void addThenExecute(T data) {
        if (this.add(data)) {
            this.execute();
        }
    }

    public synchronized void execute() {
        if (this.stopped) {
            return;
        }
        if (!this.running) {
            this.running = true;
            this.executor.execute(this);
        }
    }

    public abstract void handle(List<T> var1);

    public void start() {
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
        this.queue.clear();
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < 10; ++i) {
                this.loopRun();
            }
        }
        finally {
            this.running = false;
        }
        if (!this.queue.isEmpty()) {
            this.execute();
        }
    }

    public void clear() {
        this.queue.clear();
    }

    private void loopRun() {
        if (this.stopped) {
            return;
        }
        LinkedList data = new LinkedList();
        this.queue.drainTo(data);
        if (data.isEmpty()) {
            return;
        }
        this.handle(data);
    }
}

