/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.io.FirstResourceLoader;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.FileUtils;
import vip.justlive.oxygen.core.util.IoUtils;
import vip.justlive.oxygen.core.util.SnowflakeIdWorker;

public final class Templates {
    private static final Map<String, Path> CACHE = new ConcurrentHashMap<String, Path>(4);
    private static final File BASE_DIR = FileUtils.createTempDir("templates", new String[0]);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String template(String path) {
        SourceResource sourceResource = new FirstResourceLoader(path).getResource();
        if (sourceResource == null) {
            throw Exceptions.fail(String.format("template [%s] not found", path));
        }
        try (InputStream is = sourceResource.getInputStream();){
            String string = IoUtils.toString(is, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static String cachedTemplate(String path) {
        try {
            Path templatePath = CACHE.get(path);
            if (templatePath != null) {
                return new String(Files.readAllBytes(templatePath), StandardCharsets.UTF_8);
            }
            String template = Templates.template(path);
            File savedFile = new File(BASE_DIR, String.valueOf(SnowflakeIdWorker.defaultNextId()));
            templatePath = savedFile.toPath();
            Files.copy(new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8)), templatePath, new CopyOption[0]);
            CACHE.put(path, templatePath);
            return template;
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    private Templates() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

