/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.template;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.template.TemplateEngine;
import vip.justlive.oxygen.core.util.ExpiringMap;
import vip.justlive.oxygen.core.util.TokenParser;

public class SimpleTemplateEngine
implements TemplateEngine {
    private static final TokenParser SCRIPT_PARSER = new TokenParser("#{", "}");
    private static final TokenParser VARS_PARSER = new TokenParser("${", "}");
    private static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("js");
    private static final Compilable COMPILABLE = ENGINE instanceof Compilable ? (Compilable)((Object)ENGINE) : null;
    private static final ExpiringMap<String, TemplateSpec> CACHE = ExpiringMap.builder().name("Simple-Template").expiration(30L, TimeUnit.MINUTES).expiringPolicy(ExpiringMap.ExpiringPolicy.ACCESSED).build();

    @Override
    public String render(String template, Map<String, Object> attrs) {
        StringWriter writer = new StringWriter();
        this.render(template, attrs, writer);
        return writer.toString();
    }

    @Override
    public void render(String template, Map<String, Object> attrs, Writer writer) {
        TemplateSpec spec = CACHE.get(template);
        try {
            if (spec != null) {
                spec.apply(attrs, writer);
                return;
            }
            spec = new TemplateSpec(template);
            CACHE.put(template, spec);
            spec.apply(attrs, writer);
        }
        catch (ScriptException e) {
            throw Exceptions.wrap(e);
        }
    }

    static class TemplateSpec {
        String parsed;
        CompiledScript compiledScript;
        List<String> data = new ArrayList<String>();

        TemplateSpec(String template) throws ScriptException {
            this.parsed = String.format("var func = function(){%s};func();", SCRIPT_PARSER.parse(template, text -> VARS_PARSER.parse((String)text, a -> {
                this.data.add((String)a);
                return String.format("$out.write($data[%s]);", this.data.size() - 1);
            }, b -> String.format("$out.write(''+(%s));", b)), UnaryOperator.identity()));
            if (COMPILABLE != null) {
                this.compiledScript = COMPILABLE.compile(this.parsed);
            } else {
                this.parsed = null;
            }
        }

        void apply(Map<String, Object> attrs, Writer writer) throws ScriptException {
            Bindings bindings = ENGINE.createBindings();
            SimpleScriptContext ctx = new SimpleScriptContext();
            ctx.setBindings(bindings, 100);
            bindings.putAll((Map<? extends String, ? extends Object>)attrs);
            bindings.put("$out", (Object)writer);
            bindings.put("$data", (Object)this.data);
            if (this.compiledScript != null) {
                this.compiledScript.eval(bindings);
            } else {
                ENGINE.eval(this.parsed, bindings);
            }
        }
    }
}

