/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.scan;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.scan.ClassScanner;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.JarFileInfo;
import vip.justlive.oxygen.core.util.PathMatcher;
import vip.justlive.oxygen.core.util.Urls;

public class DefaultClassScanner
implements ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultClassScanner.class);
    private static final String CLASS_SUFFIX = ".class";
    private static final String CLASS_PATH_MULTI_SUFFIX = "/**/*.class";
    private static final Map<String, Set<Class<?>>> CACHE = new HashMap(2);
    private final ClassLoader loader;

    public DefaultClassScanner() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public DefaultClassScanner(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public Set<Class<?>> scan(String ... packages) {
        HashSet classes = new HashSet();
        for (String pkg : packages) {
            String transfer = pkg.replace(".", "/") + CLASS_PATH_MULTI_SUFFIX;
            try {
                this.findMatchPath(transfer, classes);
            }
            catch (IOException e) {
                log.warn("scan package [{}] -> [{}] failed", new Object[]{pkg, transfer, e});
            }
        }
        return classes;
    }

    private void findMatchPath(String location, Set<Class<?>> classes) throws IOException {
        Set<Class<?>> result = CACHE.get(location);
        if (result == null) {
            result = new HashSet(2);
            String rootPath = PathMatcher.getRootDir(location);
            String subPattern = location.substring(rootPath.length());
            Enumeration<URL> urls = this.loader.getResources(Urls.cutRootPath(rootPath));
            while (urls.hasMoreElements()) {
                URL rootUrl = urls.nextElement();
                if ("file".equals(rootUrl.getProtocol())) {
                    this.findFileMatchPath(rootPath, rootUrl, subPattern, result);
                    continue;
                }
                if (!Urls.isJarURL(rootUrl)) continue;
                this.findJarMatchPath(rootUrl, subPattern, result);
            }
            CACHE.put(location, result);
        }
        classes.addAll(result);
    }

    private void findFileMatchPath(String rootPath, URL rootUrl, String subPattern, Set<Class<?>> classes) {
        File rootDir;
        try {
            rootDir = new File(Urls.toURI(rootUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            rootDir = new File(rootUrl.getFile());
        }
        Set<File> matchedFiles = PathMatcher.findMatchedFiles(rootDir, subPattern);
        for (File file : matchedFiles) {
            String className = this.pathToClassName(rootPath, rootDir, file).replace(CLASS_SUFFIX, "");
            try {
                classes.add(this.loader.loadClass(className));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.warn("class [{}] can not load ", (Object)className);
            }
        }
    }

    private void findJarMatchPath(URL rootUrl, String subPattern, Set<Class<?>> classes) throws IOException {
        try (JarFileInfo jarFileInfo = Urls.getJarFileInfo(rootUrl);){
            String rootEntryPath;
            if (log.isDebugEnabled()) {
                log.debug("Looking for matching resources in jar file [" + jarFileInfo.jarFileUrl + "]");
            }
            if ((rootEntryPath = jarFileInfo.rootEntryPath).length() > 0 && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            Enumeration<JarEntry> entries = jarFileInfo.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || !PathMatcher.match(subPattern, entryPath.substring(rootEntryPath.length()))) continue;
                String className = entryPath.replace("/", ".").replace(CLASS_SUFFIX, "");
                try {
                    classes.add(this.loader.loadClass(className));
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    log.warn("class [{}] cannot load", (Object)className);
                }
            }
        }
    }

    private String pathToClassName(String rootPath, File rootDir, File subFile) {
        return this.pathToClassName(rootPath, subFile.getAbsolutePath().replace(rootDir.getAbsolutePath(), "").replace(File.separator, "."));
    }

    private String pathToClassName(String rootPath, String subPath) {
        String className = rootPath.replace("/", ".");
        if (!className.endsWith(".")) {
            className = className.concat(".");
        }
        if (subPath.startsWith(".")) {
            return className.concat(subPath.substring(1));
        }
        return className.concat(subPath);
    }
}

