/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.scan;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.Plugin;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.config.CoreConf;
import vip.justlive.oxygen.core.scan.DefaultClassScanner;
import vip.justlive.oxygen.core.util.ClassUtils;

public class ClassScannerPlugin
implements Plugin {
    private static final Set<Class<?>> CLASSES = new HashSet();
    private static final Map<Class<? extends Annotation>, ClassStore> CACHE = new ConcurrentHashMap<Class<? extends Annotation>, ClassStore>();

    public static Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        ClassStore store = CACHE.computeIfAbsent(annotation, k -> new ClassStore());
        if (store.classes == null) {
            store.classes = new HashSet();
            for (Class<?> clazz : CLASSES) {
                if (!ClassUtils.isAnnotationPresent(clazz, annotation)) continue;
                store.classes.add(clazz);
            }
        }
        return store.classes;
    }

    public static Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        ClassStore store = CACHE.computeIfAbsent(annotation, k -> new ClassStore());
        if (store.methods == null) {
            store.methods = new HashSet<Method>();
            for (Class<?> clazz : CLASSES) {
                store.methods.addAll(ClassUtils.getMethodsAnnotatedWith(clazz, annotation));
            }
        }
        return store.methods;
    }

    public static Set<Class<?>> getClasses() {
        CoreConf config = ConfigFactory.load(CoreConf.class);
        DefaultClassScanner scanner = new DefaultClassScanner();
        HashSet<String> pkgs = new HashSet<String>(2);
        if (config.getClassScan() != null) {
            pkgs.addAll(Arrays.asList(config.getClassScan()));
        }
        pkgs.add("vip.justlive.oxygen");
        return scanner.scan(pkgs.toArray(new String[0]));
    }

    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void start() {
        CLASSES.addAll(ClassScannerPlugin.getClasses());
    }

    @Override
    public void stop() {
        CLASSES.clear();
        CACHE.clear();
    }

    static class ClassStore {
        Set<Class<?>> classes;
        Set<Method> methods;

        ClassStore() {
        }
    }
}

