/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.net.http.Part;
import vip.justlive.oxygen.core.util.Bytes;
import vip.justlive.oxygen.core.util.FileUtils;
import vip.justlive.oxygen.core.util.IoUtils;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.SnowflakeIdWorker;

public class Multipart {
    private static final String DEFAULT_BOUNDARY = "----oxygen_" + SnowflakeIdWorker.defaultNextId();
    private static final String FORM_DATA = "Content-Disposition: form-data; name=\"%s\"";
    private static final String FORM_FILE_DATA = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"";
    private final String boundary = DEFAULT_BOUNDARY;
    private List<Part> parts;

    public Multipart add(String name, String value) {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        this.parts.add(new Part(name, value));
        return this;
    }

    public Multipart add(String name, File file) {
        return this.add(name, file, null);
    }

    public Multipart add(String name, File file, String filename) {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        this.parts.add(new Part(name, file, filename));
        return this;
    }

    public byte[] toBytes(Charset charset) {
        if (this.parts == null || this.parts.isEmpty()) {
            return new byte[0];
        }
        Bytes bytes = new Bytes();
        for (Part part : this.parts) {
            if (part.isFile()) {
                this.appendFile(part, bytes, charset);
                continue;
            }
            this.appendValue(part, bytes, charset);
        }
        this.appendEnd(bytes, charset);
        return bytes.toArray();
    }

    private void appendEnd(Bytes bytes, Charset charset) {
        bytes.write("-").write("-").write(this.boundary, charset).write("-").write("-").write((byte)13).write((byte)10);
    }

    private void appendValue(Part part, Bytes bytes, Charset charset) {
        bytes.write("-").write("-").write(this.boundary, charset).write((byte)13).write((byte)10);
        bytes.write(String.format(FORM_DATA, part.getName()), charset).write((byte)13).write((byte)10);
        bytes.write((byte)13).write((byte)10);
        bytes.write(part.getValue(), charset).write((byte)13).write((byte)10);
    }

    private void appendFile(Part part, Bytes bytes, Charset charset) {
        bytes.write("-").write("-").write(this.boundary, charset).write((byte)13).write((byte)10);
        bytes.write(String.format(FORM_FILE_DATA, part.getName(), part.getFilename()), charset).write((byte)13).write((byte)10);
        bytes.write("Content-Type").write((byte)58).write((byte)32).write(MoreObjects.firstNonNull(FileUtils.parseMimeType(part.getFilename()), "application/octet-stream"));
        bytes.write((byte)13).write((byte)10).write((byte)13).write((byte)10);
        try (InputStream input = Files.newInputStream(part.getFile().toPath(), new OpenOption[0]);){
            IoUtils.copy(input, bytes);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        bytes.write((byte)13).write((byte)10);
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<Part> getParts() {
        return this.parts;
    }
}

