/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import vip.justlive.oxygen.core.net.http.HttpMethod;
import vip.justlive.oxygen.core.net.http.HttpResponse;
import vip.justlive.oxygen.core.net.http.Multipart;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.json.Json;

public class HttpRequest {
    private final String url;
    private int connectTimeout;
    private int readTimeout;
    private boolean followRedirects = true;
    private HttpMethod method;
    private Charset charset = StandardCharsets.UTF_8;
    private final Map<String, String> headers = new HashMap<String, String>(4);
    private Object queryParam;
    private Object body;
    private Multipart multipart;
    private Function<Object, byte[]> func;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;

    private HttpRequest(String url) {
        this.url = url;
    }

    public static HttpRequest url(String url) {
        return new HttpRequest(url);
    }

    public static HttpRequest get(String url) {
        return HttpRequest.url(url).method(HttpMethod.GET);
    }

    public static HttpRequest post(String url) {
        return HttpRequest.url(url).method(HttpMethod.POST);
    }

    public HttpRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpRequest connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpRequest readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public HttpRequest proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public HttpRequest hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequest queryParam(Object queryParam) {
        this.queryParam = queryParam;
        return this;
    }

    public HttpRequest formBody(Object body) {
        this.body = body;
        this.func = this::formBodyConvert;
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        return this;
    }

    public HttpRequest jsonBody(Object body) {
        this.body = body;
        this.func = this::jsonBodyConvert;
        this.headers.put("Content-Type", "application/json");
        return this;
    }

    public Multipart multipart() {
        return this.multipart(null);
    }

    public Multipart multipart(Object body) {
        this.multipart = new Multipart();
        this.headers.put("Content-Type", "multipart/form-data; boundary=" + this.multipart.getBoundary());
        this.body = body;
        this.func = this::multipartConvert;
        return this.multipart;
    }

    public HttpRequest body(Object body, Function<Object, byte[]> func) {
        this.body = body;
        this.func = func;
        return this;
    }

    public HttpResponse execute() throws IOException {
        String httpUrl = this.url;
        if (this.queryParam != null) {
            String queryString = MoreObjects.beanToQueryString(this.queryParam, true);
            if (!this.url.contains("?")) {
                httpUrl = httpUrl + "?";
            } else if (!this.url.endsWith("&")) {
                httpUrl = httpUrl + "&";
            }
            httpUrl = httpUrl + queryString;
        }
        HttpURLConnection connection = this.buildConnection(httpUrl);
        if (this.connectTimeout >= 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        connection.setInstanceFollowRedirects(this.followRedirects);
        connection.setRequestMethod(this.method.name());
        connection.setUseCaches(false);
        this.setContentType();
        this.headers.forEach(connection::addRequestProperty);
        boolean nonOutput = this.method == HttpMethod.GET || this.body == null && this.multipart == null;
        connection.setDoOutput(!nonOutput);
        if (nonOutput) {
            connection.connect();
        } else {
            byte[] bytes = this.func.apply(this.body);
            connection.setFixedLengthStreamingMode(bytes.length);
            connection.connect();
            try (OutputStream out = connection.getOutputStream();){
                out.write(bytes);
                out.flush();
            }
        }
        return new HttpResponse(connection, this.charset);
    }

    private HttpURLConnection buildConnection(String httpUrl) throws IOException {
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)new URL(httpUrl).openConnection(this.proxy) : (HttpURLConnection)new URL(httpUrl).openConnection();
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            if (this.sslSocketFactory != null) {
                https.setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                https.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return connection;
    }

    private void setContentType() {
        String contentType = this.headers.get("Content-Type");
        if (contentType != null && !contentType.contains("charset")) {
            this.headers.put("Content-Type", contentType + ";charset=" + this.charset.name());
        }
    }

    private byte[] formBodyConvert(Object obj) {
        if (obj == null) {
            return new byte[0];
        }
        return MoreObjects.beanToQueryString(obj, true).getBytes(this.charset);
    }

    private byte[] jsonBodyConvert(Object json) {
        if (json == null) {
            return new byte[0];
        }
        if (json instanceof String) {
            return ((String)json).getBytes(this.charset);
        }
        return Json.toJson(json).getBytes(this.charset);
    }

    private byte[] multipartConvert(Object body) {
        if (body != null) {
            MoreObjects.beanToMap(body).forEach((k, v) -> this.multipart.add((String)k, v.toString()));
        }
        return this.multipart.toBytes(this.charset);
    }

    public String getUrl() {
        return this.url;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getQueryParam() {
        return this.queryParam;
    }

    public Object getBody() {
        return this.body;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public Function<Object, byte[]> getFunc() {
        return this.func;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }
}

