/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.protocol;

import java.nio.ByteBuffer;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.net.aio.core.AioHandler;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.protocol.LengthFrame;

public class LengthFrameHandler
implements AioHandler {
    private static final LengthFrame BEAT = new LengthFrame().setType(-1);

    @Override
    public ByteBuffer encode(Object data, ChannelContext channelContext) {
        if (data instanceof LengthFrame) {
            LengthFrame frame = (LengthFrame)data;
            int bodySize = 0;
            if (frame.getBody() != null) {
                bodySize = frame.getBody().length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(8 + bodySize);
            buffer.putInt(bodySize);
            buffer.putInt(frame.getType());
            if (bodySize > 0) {
                buffer.put(frame.getBody());
            }
            return buffer;
        }
        throw Exceptions.fail(String.format("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d, %s -> %s", data.getClass(), LengthFrame.class));
    }

    @Override
    public Object decode(ByteBuffer buffer, int readableSize, ChannelContext channelContext) {
        if (readableSize < 8) {
            return null;
        }
        int bodySize = buffer.getInt();
        if (readableSize - 8 < bodySize) {
            return null;
        }
        LengthFrame frame = new LengthFrame().setType(buffer.getInt());
        byte[] bytes = new byte[bodySize];
        buffer.get(bytes);
        return frame.setBody(bytes);
    }

    @Override
    public void handle(Object data, ChannelContext channelContext) {
    }

    @Override
    public Object beat(ChannelContext channelContext) {
        return BEAT;
    }
}

