/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.AioHandler;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.core.Utils;
import vip.justlive.oxygen.core.util.AbstractQueueWorker;

public class ReadWorker
extends AbstractQueueWorker<ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(ReadWorker.class);
    private final AioHandler aioHandler;
    private final ChannelContext channelContext;
    private ByteBuffer lastByteBuffer = null;

    ReadWorker(ChannelContext channelContext) {
        super(channelContext.getGroupContext().getWorkerExecutor());
        this.channelContext = channelContext;
        this.aioHandler = channelContext.getGroupContext().getAioHandler();
    }

    @Override
    public void handle(List<ByteBuffer> buffers) {
        if (this.lastByteBuffer != null) {
            buffers.add(0, this.lastByteBuffer);
            this.lastByteBuffer = null;
        }
        ByteBuffer buffer = Utils.composite(buffers);
        while (buffer.hasRemaining()) {
            try {
                int position = buffer.position();
                int limit = buffer.limit();
                int readableSize = limit - position;
                Object data = this.aioHandler.decode(buffer, readableSize, this.channelContext);
                if (data != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} decoded packet successfully,{} bytes", (Object)this.channelContext, (Object)(buffer.position() - position));
                    }
                    this.channelContext.setLastReceivedAt(System.currentTimeMillis());
                    this.doHandle(data);
                    continue;
                }
                buffer.position(position);
                buffer.limit(limit);
                this.lastByteBuffer = buffer;
                if (!log.isDebugEnabled()) break;
                log.debug("{} decoded failed,remain {} bytes", (Object)this.channelContext, (Object)readableSize);
                break;
            }
            catch (Exception e) {
                log.error("aio decode error", (Throwable)e);
                this.channelContext.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandle(Object data) {
        Throwable e = null;
        try {
            this.aioHandler.handle(data, this.channelContext);
        }
        catch (Throwable exc) {
            e = exc;
        }
        finally {
            this.afterHandled(data, e);
        }
    }

    private void afterHandled(Object data, Throwable e) {
        try {
            if (this.channelContext.getGroupContext().getAioListener() != null) {
                this.channelContext.getGroupContext().getAioListener().onReadHandled(this.channelContext, data, e);
            }
        }
        catch (Exception exc) {
            log.error("{} handled listener error", (Object)this.channelContext, (Object)exc);
        }
    }
}

