/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;

public class ReadHandler
implements CompletionHandler<Integer, ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(ReadHandler.class);
    private final ChannelContext channelContext;

    @Override
    public void completed(Integer result, ByteBuffer buffer) {
        if (result <= 0) {
            if (result == -1) {
                log.info("{} target closed", (Object)this.channelContext);
            } else {
                log.warn("{} read result {}", (Object)this.channelContext, (Object)result);
            }
            this.channelContext.close();
            return;
        }
        buffer.flip();
        this.channelContext.read(buffer);
        if (!this.channelContext.isClosed()) {
            buffer.clear();
            this.channelContext.getChannel().read(buffer, buffer, this);
        }
    }

    @Override
    public void failed(Throwable exc, ByteBuffer buffer) {
        if (!this.channelContext.isClosed() || !(exc instanceof AsynchronousCloseException)) {
            log.error("{} read error", (Object)this.channelContext, (Object)exc);
        }
        this.channelContext.close();
    }

    public ReadHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }
}

