/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;

public class ConnectHandler
implements CompletionHandler<Void, ChannelContext> {
    private static final Logger log = LoggerFactory.getLogger(ConnectHandler.class);
    static final ConnectHandler INSTANCE = new ConnectHandler();

    @Override
    public void completed(Void result, ChannelContext channelContext) {
        ByteBuffer buffer = ByteBuffer.allocate(channelContext.getGroupContext().getBufferCapacity());
        buffer.order(ByteOrder.BIG_ENDIAN);
        channelContext.getChannel().read(buffer, buffer, channelContext.getReadHandler());
        channelContext.start();
        if (channelContext.getGroupContext().getAioListener() != null) {
            channelContext.getGroupContext().getAioListener().onConnected(channelContext);
        }
        channelContext.complete();
    }

    @Override
    public void failed(Throwable exc, ChannelContext channelContext) {
        log.error("Aio client {} connected error", (Object)channelContext, (Object)exc);
        channelContext.completeExceptionally(exc);
        channelContext.close();
    }
}

