/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.net.aio.core.BeatProcessor;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.core.ClientAioListener;
import vip.justlive.oxygen.core.net.aio.core.ComposeAioListener;
import vip.justlive.oxygen.core.net.aio.core.ConnectHandler;
import vip.justlive.oxygen.core.net.aio.core.GroupContext;
import vip.justlive.oxygen.core.net.aio.core.Utils;
import vip.justlive.oxygen.core.util.SystemUtils;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class Client {
    private final GroupContext groupContext;

    public Client(GroupContext groupContext) {
        this.groupContext = groupContext;
    }

    public ChannelContext connect(String host, int port) throws IOException {
        return this.connect(new InetSocketAddress(host, port));
    }

    public ChannelContext connect(InetSocketAddress remote) throws IOException {
        return this.connect(remote, new InetSocketAddress(SystemUtils.findAvailablePort()));
    }

    public ChannelContext connect(InetSocketAddress remote, InetSocketAddress bind) throws IOException {
        AsynchronousChannelGroup channelGroup = AsynchronousChannelGroup.withThreadPool(this.groupContext.getGroupExecutor());
        this.groupContext.setChannelGroup(channelGroup);
        AsynchronousSocketChannel channel = Utils.create(this.groupContext, bind);
        this.groupContext.setAioListener(new ComposeAioListener().add(ClientAioListener.INSTANCE).add(this.groupContext.getAioListener()));
        ChannelContext channelContext = new ChannelContext(this.groupContext, channel, false);
        channelContext.setServerAddress(remote);
        channel.connect(remote, channelContext, ConnectHandler.INSTANCE);
        BeatProcessor beat = new BeatProcessor(channelContext);
        ThreadUtils.globalTimer().scheduleWithDelay(beat, this.groupContext.getBeatInterval(), TimeUnit.MILLISECONDS, beat);
        return channelContext;
    }

    public void close() {
        this.groupContext.close();
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }
}

