/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.net.aio.core.GroupContext;
import vip.justlive.oxygen.core.net.aio.core.ReadHandler;
import vip.justlive.oxygen.core.net.aio.core.ReadWorker;
import vip.justlive.oxygen.core.net.aio.core.Utils;
import vip.justlive.oxygen.core.net.aio.core.WriteHandler;
import vip.justlive.oxygen.core.net.aio.core.WriteWorker;
import vip.justlive.oxygen.core.util.SnowflakeIdWorker;

public class ChannelContext {
    private final long id;
    private final boolean server;
    private final GroupContext groupContext;
    private final ReadWorker readWorker;
    private final ReadHandler readHandler;
    private final WriteWorker writeWorker;
    private final WriteHandler writeHandler;
    private final Map<String, Object> attrs = new ConcurrentHashMap<String, Object>(4);
    private AsynchronousSocketChannel channel;
    private InetSocketAddress address;
    private InetSocketAddress serverAddress;
    private volatile boolean closed;
    private CompletableFuture<Void> future;
    private long createAt = System.currentTimeMillis();
    private long lastReceivedAt = -1L;
    private long lastSentAt = -1L;
    private int retryAttempts = 0;

    public ChannelContext(GroupContext groupContext, AsynchronousSocketChannel channel) {
        this(groupContext, channel, true);
    }

    public ChannelContext(GroupContext groupContext, AsynchronousSocketChannel channel, boolean server) {
        this(SnowflakeIdWorker.defaultNextId(), groupContext, channel, server);
    }

    public ChannelContext(long id, GroupContext groupContext, AsynchronousSocketChannel channel, boolean server) {
        this.id = id;
        this.server = server;
        this.groupContext = groupContext;
        this.readWorker = new ReadWorker(this);
        this.readHandler = new ReadHandler(this);
        this.writeWorker = new WriteWorker(this);
        this.writeHandler = new WriteHandler(this);
        this.setChannel(channel);
    }

    public void setChannel(AsynchronousSocketChannel channel) {
        this.channel = channel;
        try {
            this.address = this.isServer() ? (InetSocketAddress)channel.getRemoteAddress() : (InetSocketAddress)channel.getLocalAddress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.future = new CompletableFuture();
    }

    public void write(Object data) {
        if (this.closed) {
            return;
        }
        this.writeWorker.addThenExecute(data);
    }

    public synchronized void start() {
        this.closed = false;
        this.readWorker.start();
        this.writeWorker.start();
        this.retryAttempts = 0;
        this.groupContext.bind(this);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.groupContext.unbind(this);
        try {
            if (this.groupContext.getAioListener() != null) {
                this.groupContext.getAioListener().onClosed(this);
            }
        }
        finally {
            this.readWorker.stop();
            this.writeWorker.stop();
            Utils.close(this.channel);
            this.clearAttrs();
        }
    }

    public void addAttr(String key, Object value) {
        this.attrs.put(key, value);
    }

    public Object getAttr(String key) {
        return this.attrs.get(key);
    }

    public Object removeAttr(String key) {
        return this.attrs.remove(key);
    }

    public void clearAttrs() {
        this.attrs.clear();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelContext) {
            ChannelContext other = (ChannelContext)obj;
            return this.id == other.id && this.channel == other.channel;
        }
        return false;
    }

    public String toString() {
        return String.format("[%s:%s]", this.id, this.address);
    }

    public void join() {
        if (this.future != null) {
            this.future.join();
        }
    }

    void complete() {
        if (this.future != null) {
            this.future.complete(null);
        }
    }

    void completeExceptionally(Throwable ex) {
        if (this.future != null) {
            this.future.completeExceptionally(ex);
        }
    }

    void read(ByteBuffer buffer) {
        if (this.closed) {
            return;
        }
        ByteBuffer ret = ByteBuffer.allocate(buffer.limit() - buffer.position());
        ret.put(buffer);
        ret.flip();
        this.readWorker.addThenExecute(ret);
    }

    public long getId() {
        return this.id;
    }

    public boolean isServer() {
        return this.server;
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }

    public ReadWorker getReadWorker() {
        return this.readWorker;
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteWorker getWriteWorker() {
        return this.writeWorker;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public long getCreateAt() {
        return this.createAt;
    }

    public long getLastReceivedAt() {
        return this.lastReceivedAt;
    }

    public long getLastSentAt() {
        return this.lastSentAt;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public ChannelContext setAddress(InetSocketAddress address) {
        this.address = address;
        return this;
    }

    public ChannelContext setServerAddress(InetSocketAddress serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    public ChannelContext setClosed(boolean closed) {
        this.closed = closed;
        return this;
    }

    public ChannelContext setFuture(CompletableFuture<Void> future) {
        this.future = future;
        return this;
    }

    public ChannelContext setCreateAt(long createAt) {
        this.createAt = createAt;
        return this;
    }

    public ChannelContext setLastReceivedAt(long lastReceivedAt) {
        this.lastReceivedAt = lastReceivedAt;
        return this;
    }

    public ChannelContext setLastSentAt(long lastSentAt) {
        this.lastSentAt = lastSentAt;
        return this;
    }

    public ChannelContext setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return this;
    }
}

