/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.core.Server;

public class AcceptHandler
implements CompletionHandler<AsynchronousSocketChannel, Server> {
    private static final Logger log = LoggerFactory.getLogger(AcceptHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(AsynchronousSocketChannel channel, Server server) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Aio accept {}", (Object)channel);
            }
            if (!channel.isOpen()) {
                log.warn("channel has closed {}", (Object)channel);
                return;
            }
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            ChannelContext channelContext = new ChannelContext(server.getGroupContext(), channel);
            channelContext.setServerAddress(server.getServerAddress());
            channelContext.start();
            ByteBuffer buffer = ByteBuffer.allocate(server.getGroupContext().getBufferCapacity());
            buffer.order(ByteOrder.BIG_ENDIAN);
            channel.read(buffer, buffer, channelContext.getReadHandler());
            if (server.getGroupContext().getAioListener() != null) {
                server.getGroupContext().getAioListener().onConnected(channelContext);
            }
        }
        catch (Exception e) {
            log.error("Aio accept completed error", (Throwable)e);
        }
        finally {
            server.getServerChannel().accept(server, this);
        }
    }

    @Override
    public void failed(Throwable exc, Server server) {
        log.error("Aio accept error", exc);
        if (exc instanceof ClosedChannelException && server.getGroupContext().isStopped()) {
            return;
        }
        server.getServerChannel().accept(server, this);
    }
}

