/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.util.Properties;
import vip.justlive.oxygen.core.util.PlaceHolderHelper;

@FunctionalInterface
public interface PropertySource {
    public Properties props();

    default public String getProperty(String key) {
        String value = this.props().getProperty(key);
        if (value == null) {
            return null;
        }
        return this.getPlaceholderProperty(value);
    }

    default public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    default public String getPlaceholderProperty(String placeholder) {
        return PlaceHolderHelper.DEFAULT_HELPER.replacePlaceholders(placeholder, this.props());
    }

    default public boolean containPrefix(String prefix) {
        Properties properties = this.props();
        for (Object key : properties.keySet()) {
            if (!key.toString().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

